/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.retry;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.retry.RetryConfig;
import com.jn.langx.util.retry.RetryInfo;
import com.jn.langx.util.retry.ThreadSleepWaitStrategy;
import com.jn.langx.util.retry.WaitStrategy;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class Retryer<R> {
    private static final Logger LOGGER = Loggers.getLogger(Retryer.class);
    @NonNull
    private RetryConfig config;
    @NonNull
    private Predicate<R> resultRetryPredicate;
    @NonNull
    private Predicate<Throwable> errorRetryPredicate;
    @NonNull
    private Consumer<RetryInfo<R>> attemptsListener;
    @NonNull
    private WaitStrategy waitStrategy;

    public Retryer(RetryConfig config) {
        this(null, config);
    }

    public Retryer(Predicate<Throwable> retryPredicate, RetryConfig config) {
        this(retryPredicate, null, config, null);
    }

    public Retryer(Predicate<Throwable> errorRetryPredicate, Predicate<R> resultRetryPredicate, RetryConfig config, Consumer<RetryInfo<R>> attemptsListener) {
        this(errorRetryPredicate, resultRetryPredicate, config, attemptsListener, null);
    }

    public Retryer(Predicate<Throwable> errorRetryPredicate, Predicate<R> resultRetryPredicate, RetryConfig config, Consumer<RetryInfo<R>> attemptsListener, WaitStrategy waitStrategy) {
        this.errorRetryPredicate = errorRetryPredicate == null ? Functions.truePredicate() : errorRetryPredicate;
        this.resultRetryPredicate = resultRetryPredicate == null ? Functions.falsePredicate() : resultRetryPredicate;
        this.attemptsListener = attemptsListener == null ? Functions.noopConsumer() : attemptsListener;
        this.config = config;
        this.waitStrategy = waitStrategy == null ? new ThreadSleepWaitStrategy() : waitStrategy;
    }

    public static <R> R execute(Predicate<Throwable> errorRetryPredicate, Predicate<R> resultRetryPredicate, RetryConfig retryConfig, Consumer<RetryInfo<R>> attemptsListener, Callable<R> task) throws Exception {
        Retryer<R> retryer = new Retryer<R>(errorRetryPredicate, resultRetryPredicate, retryConfig, attemptsListener);
        return super.executeWithRetry(null, task);
    }

    public R execute(Callable<R> task) {
        return this.executeWithRetry(null, task);
    }

    private R executeWithRetry(RetryInfo<R> retryInfo, Callable<R> task) {
        if (retryInfo == null || retryInfo.getAttempts() < 1) {
            retryInfo = new RetryInfo(1, this.config.getMaxAttempts(), System.currentTimeMillis(), this.config.getTimeUnit().toMillis(this.config.getTimeout()));
        }
        try {
            if (retryInfo.isFirstAttempts() && this.config.getDelay() > 0) {
                this.waitStrategy.await(this.config.getTimeUnit().toMillis(this.config.getDelay()));
            }
            R r = task.call();
            retryInfo.setResult(r);
        }
        catch (Throwable e) {
            retryInfo.setError(e);
        }
        if (!this.judgeRetryAndWait(retryInfo)) {
            if (retryInfo.hasError()) {
                throw new RuntimeException(retryInfo.getError());
            }
            return retryInfo.getResult();
        }
        return this.executeWithRetry(retryInfo.nextAttempts(), task);
    }

    private boolean judgeRetryAndWait(RetryInfo<R> retryInfo) {
        boolean needRetry;
        block6: {
            boolean bl = needRetry = !Retryer.isExhausted(retryInfo.getAttempts(), this.config.getMaxAttempts()) && !Retryer.isExhaustedTimeout(retryInfo.getStartTime(), retryInfo.getTimeout()) && retryInfo.hasError() ? this.errorRetryPredicate.test(retryInfo.getError()) : this.resultRetryPredicate.test(retryInfo.getResult());
            if (needRetry) {
                long backoffMillis = this.config.getBackoffPolicy().getBackoffTime(this.config, retryInfo.getAttempts());
                if (backoffMillis < 0L) {
                    throw new RuntimeException(StringTemplates.formatWithPlaceholder("invalid retry backoff: {}", backoffMillis));
                }
                retryInfo.setBackoff(backoffMillis);
            }
            this.attemptsListener.accept(retryInfo);
            if (needRetry) {
                try {
                    if (retryInfo.getBackoff() <= 0L) {
                        return false;
                    }
                    this.waitStrategy.await(retryInfo.getBackoff());
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!retryInfo.hasError()) break block6;
                    throw new RuntimeException(retryInfo.getError());
                }
            }
        }
        return needRetry;
    }

    private static boolean isExhausted(int attempts, int maxAttempts) {
        if (maxAttempts <= 0) {
            return false;
        }
        return attempts >= maxAttempts;
    }

    private static boolean isExhaustedTimeout(long startTime, long timeout) {
        if (timeout <= 0L) {
            return false;
        }
        if (startTime <= 0L) {
            throw new RuntimeException("Illegal args, startTime: " + startTime);
        }
        return System.currentTimeMillis() > startTime + timeout;
    }
}

