/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.retry;

import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.retry.WaitStrategy;

public class ThreadSleepWaitStrategy
implements WaitStrategy {
    private long maxMills;

    public ThreadSleepWaitStrategy() {
        this(300000L);
    }

    public ThreadSleepWaitStrategy(long maxMills) {
        Preconditions.checkArgument(maxMills >= 0L);
        this.maxMills = maxMills;
    }

    @Override
    public void await(long mills) throws InterruptedException {
        Thread.sleep(Maths.maxLong(0L, Maths.minLong(mills, this.maxMills)));
    }
}

