/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.spi;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.comparator.OrderedComparator;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.spi.ServiceProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class CommonServiceProvider<T>
implements ServiceProvider<T> {
    private static Logger logger = Loggers.getLogger(CommonServiceProvider.class);
    private Predicate<T> predicate = Functions.truePredicate();
    private Comparator<T> comparator = new OrderedComparator();
    @Nullable
    private ClassLoader classLoader;

    public CommonServiceProvider() {
        this(null);
    }

    public CommonServiceProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Iterator<T> get(Class<T> serviceClass) {
        List ret = Collects.emptyArrayList();
        if (this.classLoader != null) {
            this.loadServicesInternal(serviceClass, this.classLoader, ret);
        } else {
            int serviceInstanceCount = this.loadServicesInternal(serviceClass, Thread.currentThread().getContextClassLoader(), ret);
            if (serviceInstanceCount == 0 && Thread.currentThread().getContextClassLoader() != serviceClass.getClassLoader()) {
                this.loadServicesInternal(serviceClass, serviceClass.getClassLoader(), ret);
            }
        }
        if (this.comparator != null) {
            ret = Collects.sort(ret, this.comparator);
        }
        return ret.iterator();
    }

    private int loadServicesInternal(Class<T> serviceClass, ClassLoader classLoader, Collection<T> tmpStorage) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceClass, classLoader);
        Iterator<T> iter = loader.iterator();
        int loadedServiceInstanceCount = 0;
        while (iter.hasNext()) {
            try {
                T t = iter.next();
                if (this.predicate.test(t)) {
                    tmpStorage.add(t);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++loadedServiceInstanceCount;
        }
        return loadedServiceInstanceCount;
    }

    public static <T> Iterable<T> loadService(Class<T> serviceClass) {
        return Collects.asIterable(new CommonServiceProvider<T>().get(serviceClass));
    }
}

