/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron;

import com.jn.langx.Builder;
import com.jn.langx.text.StrTokenizer;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.timing.cron.CronExpression;
import com.jn.langx.util.timing.cron.CronExpressionType;
import java.text.ParseException;

public class CronExpressionBuilder
implements Builder<CronExpression> {
    private CronExpressionType type = CronExpressionType.QUARTZ;
    private String expression;

    public CronExpressionType type() {
        return this.type;
    }

    public CronExpressionBuilder type(CronExpressionType type) {
        if (type != null) {
            this.type = type;
        }
        return this;
    }

    public String expression() {
        return this.expression;
    }

    public CronExpressionBuilder expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public CronExpression build() {
        Preconditions.checkNotEmpty(this.expression);
        String[] segments = Pipeline.of(new StrTokenizer(this.expression, " ", "\t")).filter(Functions.notEmptyPredicate()).toArray(String[].class);
        if (this.type == CronExpressionType.UNIX_LIKE && (segments.length > 6 || segments.length < 5)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Illegal cron expression: {}", this.expression));
        }
        if (this.type == CronExpressionType.QUARTZ && (segments.length > 7 || segments.length < 5)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Illegal cron expression: {}", this.expression));
        }
        if (segments.length == 5) {
            this.expression = "0 " + this.expression;
        } else if (segments.length == 6 && this.type == CronExpressionType.UNIX_LIKE) {
            this.expression = "0 " + Strings.join(" ", segments, 1);
        }
        try {
            return new CronExpression(this.expression);
        }
        catch (ParseException ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }
}

