/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.ntp;

import com.jn.langx.util.timing.ntp.RelativeTime;
import java.util.concurrent.ConcurrentHashMap;

public class RelativeTimeManager {
    private final ConcurrentHashMap<String, RelativeTime> cache = new ConcurrentHashMap();

    public void add(String machineId, long machineTime) {
        if (machineId != null) {
            RelativeTime time = new RelativeTime(machineId, machineTime);
            this.add(time);
        }
    }

    public void add(RelativeTime time) {
        if (time != null) {
            this.cache.put(time.getMachineId(), time);
        }
    }

    public RelativeTime remove(String machineId) {
        if (machineId != null) {
            return this.cache.remove(machineId);
        }
        return null;
    }

    public boolean hasMachine(String machineId) {
        if (machineId == null) {
            return false;
        }
        return this.cache.get(machineId) != null;
    }

    public long getDelteTime(String machineId) {
        if (this.hasMachine(machineId)) {
            RelativeTime t = this.cache.get(machineId);
            return t == null ? 0L : t.getDelta();
        }
        return 0L;
    }

    public long getMachineCurrentTime(String machineId) {
        return this.getMachineRelativeTime(machineId, System.currentTimeMillis());
    }

    public long getMachineRelativeTime(String machineId, long specifiedTime) {
        return specifiedTime - this.getDelteTime(machineId);
    }
}

