/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.scheduling;

import com.jn.langx.util.Dates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.timing.scheduling.InstantTrigger;
import com.jn.langx.util.timing.scheduling.Trigger;
import com.jn.langx.util.timing.scheduling.TriggerFactory;
import java.util.Date;
import java.util.List;

public class InstantTriggerFactory
implements TriggerFactory {
    private static final String NAME = "instant";
    private List<String> datePatterns = Collects.asList("yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String getName() {
        return NAME;
    }

    public void setDatePatterns(List<String> datePatterns) {
        this.datePatterns = datePatterns;
    }

    @Override
    public Trigger get(String expression) {
        Date date = Dates.parse(expression, this.datePatterns);
        return new InstantTrigger(date);
    }
}

