/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.scheduling;

import com.jn.langx.exception.ErrorHandler;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.timing.scheduling.SimpleTriggerContext;
import com.jn.langx.util.timing.scheduling.Trigger;
import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ReschedulingRunnable
implements ScheduledFuture<Object>,
Runnable {
    private final Trigger trigger;
    private final SimpleTriggerContext triggerContext = new SimpleTriggerContext();
    private ScheduledFuture currentFuture;
    private ScheduledExecutorService executor;
    private Date scheduledExecutionTime;
    private final Runnable delegateTask;
    private final ErrorHandler errorHandler;
    private final Object triggerContextMonitor = new Object();

    public ReschedulingRunnable(ScheduledExecutorService executor, Runnable delegate, Trigger trigger, ErrorHandler errorHandler) {
        Preconditions.checkNotNull(delegate, "Delegate must not be null");
        Preconditions.checkNotNull(errorHandler, "ErrorHandler must not be null");
        this.delegateTask = delegate;
        this.errorHandler = errorHandler;
        this.trigger = trigger;
        this.executor = executor;
    }

    public ReschedulingRunnable(Runnable delegate, Trigger trigger, ScheduledExecutorService executor, ErrorHandler errorHandler) {
        this(executor, delegate, trigger, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture schedule() {
        if (this.executor.isShutdown() || this.executor.isTerminated()) {
            return null;
        }
        Object object = this.triggerContextMonitor;
        synchronized (object) {
            this.scheduledExecutionTime = this.trigger.nextExecutionTime(this.triggerContext);
            if (this.scheduledExecutionTime == null) {
                return null;
            }
            long initialDelay = this.scheduledExecutionTime.getTime() - System.currentTimeMillis();
            if (initialDelay < 0L) {
                initialDelay = 0L;
            }
            this.currentFuture = this.executor.schedule(this, initialDelay, TimeUnit.MILLISECONDS);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Date actualExecutionTime = new Date();
        try {
            this.delegateTask.run();
        }
        catch (Throwable ex) {
            this.errorHandler.handle(ex);
        }
        Date completionTime = new Date();
        Object object = this.triggerContextMonitor;
        synchronized (object) {
            this.triggerContext.update(this.scheduledExecutionTime, actualExecutionTime, completionTime);
        }
        if (!this.currentFuture.isCancelled()) {
            this.schedule();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.currentFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.currentFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.currentFuture.isDone();
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        return this.currentFuture.get();
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.currentFuture.get(timeout, unit);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.currentFuture.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed other) {
        if (this == other) {
            return 0;
        }
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
    }
}

