/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.timing.timer.AbstractTimeout;
import com.jn.langx.util.timing.timer.HashedWheelBucket;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import org.slf4j.Logger;

public class HashedWheelTimeout
extends AbstractTimeout
implements Runnable {
    long remainingRounds;
    HashedWheelTimeout next;
    HashedWheelTimeout prev;
    HashedWheelBucket bucket;

    public HashedWheelTimeout(HashedWheelTimer timer, TimerTask task, long deadline) {
        super(timer, task, deadline);
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public TimerTask task() {
        return this.task;
    }

    @Override
    public boolean cancel() {
        if (!this.compareAndSetState(0, 1)) {
            return false;
        }
        ((HashedWheelTimer)this.timer).cancelledTimeouts.add(this);
        return true;
    }

    void remove() {
        HashedWheelBucket bucket = this.bucket;
        if (bucket != null) {
            bucket.remove(this);
        } else {
            ((HashedWheelTimer)this.timer).pendingTimeouts.decrementAndGet();
        }
    }

    void expire() {
        block3: {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.executeTask();
            }
            catch (Throwable t) {
                Logger logger = Loggers.getLogger(HashedWheelTimeout.class);
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
            }
        }
    }

    public String toString() {
        long currentTime = System.nanoTime();
        long remaining = this.deadline - currentTime + ((HashedWheelTimer)this.timer).startTime;
        StringBuilder buf = new StringBuilder(192).append(Reflects.getSimpleClassName(this)).append('(').append("deadline: ");
        if (remaining > 0L) {
            buf.append(remaining).append(" ns later");
        } else if (remaining < 0L) {
            buf.append(-remaining).append(" ns ago");
        } else {
            buf.append("now");
        }
        if (this.isCancelled()) {
            buf.append(", cancelled");
        }
        return buf.append(", task: ").append(this.task()).append(')').toString();
    }
}

