/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.concurrent.executor.ImmediateExecutor;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.memory.leak.ResourceLeakDetector;
import com.jn.langx.util.memory.leak.ResourceLeakDetectorFactory;
import com.jn.langx.util.memory.leak.ResourceLeakTracker;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.retry.ThreadSleepWaitStrategy;
import com.jn.langx.util.retry.WaitStrategy;
import com.jn.langx.util.timing.timer.AbstractTimer;
import com.jn.langx.util.timing.timer.DistinctHashedWheelTimeoutFactory;
import com.jn.langx.util.timing.timer.HashedWheelBucket;
import com.jn.langx.util.timing.timer.HashedWheelTimeout;
import com.jn.langx.util.timing.timer.HashedWheelTimeoutFactory;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.TimeoutFactory;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class HashedWheelTimer
extends AbstractTimer {
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final AtomicBoolean WARNED_TOO_MANY_INSTANCES = new AtomicBoolean();
    private static final int INSTANCE_COUNT_LIMIT = 64;
    private static final long MILLISECOND_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
    private final ResourceLeakTracker<HashedWheelTimer> leak;
    private final Worker worker = new Worker();
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState;
    private final long tickDuration;
    private final HashedWheelBucket[] wheel;
    private final WaitStrategy waitStrategy;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    final Queue<HashedWheelTimeout> timeouts = new LinkedBlockingQueue<HashedWheelTimeout>();
    final Queue<HashedWheelTimeout> cancelledTimeouts = new LinkedBlockingQueue<HashedWheelTimeout>();
    final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private final long maxPendingTimeouts;
    volatile long startTime;
    final TimeoutFactory<HashedWheelTimer, ? extends HashedWheelTimeout> timeoutFactory;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long tickDuration, TimeUnit unit) {
        this(Executors.defaultThreadFactory(), tickDuration, unit);
    }

    public HashedWheelTimer(long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(Executors.defaultThreadFactory(), tickDuration, unit, ticksPerWheel);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit) {
        this(threadFactory, tickDuration, unit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(threadFactory, tickDuration, unit, ticksPerWheel, false);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection) {
        this(threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, -1L);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts) {
        this(threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, maxPendingTimeouts, ImmediateExecutor.INSTANCE);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts, Executor taskExecutor) {
        this(threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, maxPendingTimeouts, taskExecutor, HashedWheelTimeoutFactory.INSTANCE);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts, Executor taskExecutor, TimeoutFactory<HashedWheelTimer, ? extends HashedWheelTimeout> timeoutFactory) {
        this(threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, maxPendingTimeouts, taskExecutor, timeoutFactory, null);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts, Executor taskExecutor, TimeoutFactory<HashedWheelTimer, ? extends HashedWheelTimeout> timeoutFactory, WaitStrategy waitStrategy) {
        Preconditions.checkNotNull(threadFactory, "threadFactory is null");
        Preconditions.checkNotNull(unit, "unit is null");
        if (tickDuration <= 0L) {
            throw new IllegalArgumentException("tickDuration must be greater than 0: " + tickDuration);
        }
        if (ticksPerWheel <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + ticksPerWheel);
        }
        this.setTaskExecutor(taskExecutor);
        this.timeoutFactory = Objs.useValueIfEmpty(timeoutFactory, HashedWheelTimeoutFactory.INSTANCE);
        this.wheel = HashedWheelTimer.createWheel(ticksPerWheel);
        this.mask = this.wheel.length - 1;
        long duration = unit.toNanos(tickDuration);
        if (duration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", tickDuration, Long.MAX_VALUE / (long)this.wheel.length));
        }
        if (duration < MILLISECOND_NANOS) {
            Logger logger = Loggers.getLogger(HashedWheelTimer.class);
            if (logger.isWarnEnabled()) {
                logger.warn(StringTemplates.formatWithCStyle("Configured tickDuration %d smaller then %d, using 1ms.", tickDuration, MILLISECOND_NANOS));
            }
            this.tickDuration = MILLISECOND_NANOS;
        } else {
            this.tickDuration = duration;
        }
        this.waitStrategy = waitStrategy == null ? new ThreadSleepWaitStrategy(31536000000L) : waitStrategy;
        this.workerThread = threadFactory.newThread(this.worker);
        this.leak = leakDetection || !this.workerThread.isDaemon() ? leakDetector.track(this) : null;
        this.maxPendingTimeouts = maxPendingTimeouts;
        if (INSTANCE_COUNTER.incrementAndGet() > 64 && WARNED_TOO_MANY_INSTANCES.compareAndSet(false, true)) {
            HashedWheelTimer.reportTooManyInstances();
        }
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
            }
        }
    }

    private static HashedWheelBucket[] createWheel(int ticksPerWheel) {
        if (ticksPerWheel <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + ticksPerWheel);
        }
        if (ticksPerWheel > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + ticksPerWheel);
        }
        ticksPerWheel = HashedWheelTimer.normalizeTicksPerWheel(ticksPerWheel);
        HashedWheelBucket[] wheel = new HashedWheelBucket[ticksPerWheel];
        for (int i = 0; i < wheel.length; ++i) {
            wheel[i] = new HashedWheelBucket();
        }
        return wheel;
    }

    private static int normalizeTicksPerWheel(int ticksPerWheel) {
        int normalizedTicksPerWheel;
        for (normalizedTicksPerWheel = 1; normalizedTicksPerWheel < ticksPerWheel; normalizedTicksPerWheel <<= 1) {
        }
        return normalizedTicksPerWheel;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) {
                    this.workerThread.start();
                }
                this.running = true;
                break;
            }
            case 1: {
                this.running = true;
                break;
            }
            case 2: {
                this.running = false;
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException ignore) {
                boolean interrupted = Thread.interrupted();
                if (!interrupted) continue;
            }
        }
    }

    @Override
    public Set<Timeout> stop() {
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        this.running = false;
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
                if (this.leak != null) {
                    boolean closed = this.leak.close(this);
                    assert (closed);
                }
            }
            return Collections.emptySet();
        }
        try {
            boolean interrupted = false;
            while (this.workerThread.isAlive()) {
                this.workerThread.interrupt();
                try {
                    this.workerThread.join(100L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            INSTANCE_COUNTER.decrementAndGet();
            if (this.leak != null) {
                boolean closed = this.leak.close(this);
                assert (closed);
            }
        }
        return this.worker.unprocessedTimeouts();
    }

    @Override
    public Timeout newTimeout(Runnable task, long delay, TimeUnit unit) {
        return this.newTimeout(new RunnableToTimerTaskAdapter(task), delay, unit);
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        long pendingTimeoutsCount = this.pendingTimeouts.incrementAndGet();
        if (this.maxPendingTimeouts > 0L && pendingTimeoutsCount > this.maxPendingTimeouts) {
            this.pendingTimeouts.decrementAndGet();
            throw new RejectedExecutionException("Number of pending timeouts (" + pendingTimeoutsCount + ") is greater than or equal to maximum allowed pending timeouts (" + this.maxPendingTimeouts + ")");
        }
        this.start();
        long deadline = System.nanoTime() + unit.toNanos(delay) - this.startTime;
        if (delay > 0L && deadline < 0L) {
            deadline = Long.MAX_VALUE;
        }
        HashedWheelTimeout timeout = this.timeoutFactory.create(this, task, deadline);
        this.timeouts.add(timeout);
        return timeout;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    private static void reportTooManyInstances() {
        Logger logger = Loggers.getLogger(HashedWheelTimer.class);
        if (logger.isErrorEnabled()) {
            String resourceType = Reflects.getSimpleClassName(HashedWheelTimer.class);
            logger.error("You are creating too many {} instances. {} is a shared resource that must be reused across the JVM,so that only a few instances are created.", (Object)resourceType, (Object)resourceType);
        }
    }

    @Override
    public boolean isDistinctSupported() {
        return this.timeoutFactory instanceof DistinctHashedWheelTimeoutFactory;
    }

    private final class Worker
    implements Runnable {
        private final Set<Timeout> unprocessedTimeouts = new HashSet<Timeout>();
        private long tick;

        private Worker() {
        }

        @Override
        public void run() {
            HashedWheelTimeout timeout;
            HashedWheelTimer.this.startTime = System.nanoTime();
            if (HashedWheelTimer.this.startTime == 0L) {
                HashedWheelTimer.this.startTime = 1L;
            }
            HashedWheelTimer.this.startTimeInitialized.countDown();
            do {
                long deadline;
                if ((deadline = this.waitForNextTick()) <= 0L) continue;
                int idx = (int)(this.tick & (long)HashedWheelTimer.this.mask);
                this.processCancelledTasks();
                HashedWheelBucket bucket = HashedWheelTimer.this.wheel[idx];
                this.transferTimeoutsToBuckets();
                bucket.expireTimeouts(deadline);
                ++this.tick;
            } while (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 1);
            for (HashedWheelBucket bucket : HashedWheelTimer.this.wheel) {
                bucket.clearTimeouts(this.unprocessedTimeouts);
            }
            while ((timeout = HashedWheelTimer.this.timeouts.poll()) != null) {
                if (timeout.isCancelled()) continue;
                this.unprocessedTimeouts.add(timeout);
            }
            this.processCancelledTasks();
        }

        private void transferTimeoutsToBuckets() {
            HashedWheelTimeout timeout;
            for (int i = 0; i < 100000 && (timeout = HashedWheelTimer.this.timeouts.poll()) != null; ++i) {
                if (timeout.state() == 1) continue;
                long calculated = timeout.deadline / HashedWheelTimer.this.tickDuration;
                timeout.remainingRounds = (calculated - this.tick) / (long)HashedWheelTimer.this.wheel.length;
                long ticks = Math.max(calculated, this.tick);
                int stopIndex = (int)(ticks & (long)HashedWheelTimer.this.mask);
                HashedWheelBucket bucket = HashedWheelTimer.this.wheel[stopIndex];
                bucket.addTimeout(timeout);
            }
        }

        private void processCancelledTasks() {
            HashedWheelTimeout timeout;
            while ((timeout = HashedWheelTimer.this.cancelledTimeouts.poll()) != null) {
                try {
                    timeout.remove();
                }
                catch (Throwable t) {
                    Logger logger = Loggers.getLogger(HashedWheelTimer.class);
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("An exception was thrown while process a cancellation task", t);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long deadline = HashedWheelTimer.this.tickDuration * (this.tick + 1L);
            while (true) {
                long currentTime;
                long sleepTimeMs;
                if ((sleepTimeMs = (deadline - (currentTime = System.nanoTime() - HashedWheelTimer.this.startTime) + 999999L) / 1000000L) <= 0L) {
                    if (currentTime != Long.MIN_VALUE) return currentTime;
                    return -9223372036854775807L;
                }
                if (Platform.isWindows) {
                    sleepTimeMs = sleepTimeMs / 10L * 10L;
                }
                try {
                    HashedWheelTimer.this.waitStrategy.await(sleepTimeMs);
                    continue;
                }
                catch (InterruptedException ignored) {
                    boolean interrupted = Thread.interrupted();
                    if (interrupted) {
                        // empty if block
                    }
                    if (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 2) return Long.MIN_VALUE;
                    continue;
                }
                break;
            }
        }

        public Set<Timeout> unprocessedTimeouts() {
            return Collections.unmodifiableSet(this.unprocessedTimeouts);
        }
    }
}

