/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.exception.ErrorHandler;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.timing.scheduling.SimpleTriggerContext;
import com.jn.langx.util.timing.scheduling.Trigger;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ReschedulingTask
implements Timeout,
TimerTask {
    private Timeout timeout;
    private Timer timer;
    private final Trigger trigger;
    private final SimpleTriggerContext triggerContext = new SimpleTriggerContext();
    private volatile Date scheduledExecutionTime;
    private final TimerTask delegateTask;
    private final ErrorHandler errorHandler;
    private final Object triggerContextMonitor = new Object();

    public ReschedulingTask(Timer timer, Runnable task, Trigger trigger, ErrorHandler errorHandler) {
        this(timer, new RunnableToTimerTaskAdapter(Preconditions.checkNotNull(task, "task is required")), trigger, errorHandler);
    }

    public ReschedulingTask(Timer timer, TimerTask task, Trigger trigger, ErrorHandler errorHandler) {
        Preconditions.checkNotNull(task, "task must not be null");
        Preconditions.checkNotNull(errorHandler, "ErrorHandler must not be null");
        this.timer = timer;
        this.delegateTask = task;
        this.trigger = trigger;
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeout schedule() {
        if (this.timer.isRunning()) {
            Object object = this.triggerContextMonitor;
            synchronized (object) {
                this.scheduledExecutionTime = this.trigger.nextExecutionTime(this.triggerContext);
                if (this.scheduledExecutionTime == null) {
                    return null;
                }
                long initialDelay = this.scheduledExecutionTime.getTime() - System.currentTimeMillis();
                if (initialDelay < 0L) {
                    initialDelay = 0L;
                }
                this.timeout = this.timer.newTimeout(this, initialDelay, TimeUnit.MILLISECONDS);
                return this;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Timeout timeout) throws Exception {
        Date actualExecutionTime = new Date();
        try {
            this.delegateTask.run(timeout);
        }
        catch (Throwable ex) {
            this.errorHandler.handle(ex);
        }
        Date completionTime = new Date();
        Object object = this.triggerContextMonitor;
        synchronized (object) {
            this.triggerContext.update(this.scheduledExecutionTime, actualExecutionTime, completionTime);
        }
        if (!this.timeout.isCancelled()) {
            this.schedule();
        }
    }

    @Override
    public Timer timer() {
        return this.timeout.timer();
    }

    @Override
    public TimerTask task() {
        return this.timeout.task();
    }

    @Override
    public boolean isExpired() {
        return this.timeout.isExpired();
    }

    @Override
    public boolean isCancelled() {
        return this.timeout.isCancelled();
    }

    @Override
    public boolean cancel() {
        return this.timeout.cancel();
    }
}

