/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer.immediate;

import com.jn.langx.util.timing.timer.AbstractTimer;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.TimerTask;
import com.jn.langx.util.timing.timer.immediate.ImmediateTimeout;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ImmediateTimer
extends AbstractTimer {
    public ImmediateTimer() {
        this.running = true;
    }

    public ImmediateTimer(Executor e) {
        this();
        this.setTaskExecutor(e);
    }

    @Override
    public Timeout newTimeout(Runnable task, long delay, TimeUnit unit) {
        return this.newTimeout(new RunnableToTimerTaskAdapter(task), delay, unit);
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        long deadline = System.currentTimeMillis();
        ImmediateTimeout timeout = new ImmediateTimeout(this, task, deadline);
        timeout.executeTask();
        return timeout;
    }

    @Override
    public Set<Timeout> stop() {
        this.running = false;
        return null;
    }
}

