/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer.javatimer;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.timing.timer.AbstractTimer;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.TimerTask;
import com.jn.langx.util.timing.timer.javatimer.JavaTimeout;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class JavaTimer
extends AbstractTimer {
    private Timer jtimer;

    public JavaTimer(Timer timer, Executor executor) {
        this.jtimer = timer;
        this.setTaskExecutor(executor);
        this.running = true;
    }

    @Override
    public Timeout newTimeout(Runnable task, long delay, TimeUnit unit) {
        return this.newTimeout(new RunnableToTimerTaskAdapter(task), delay, unit);
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        long delayInMills = unit.toMillis(delay);
        long deadline = System.currentTimeMillis() + delayInMills;
        final JavaTimeout timeout = new JavaTimeout(this, task, deadline);
        java.util.TimerTask taskRef = new java.util.TimerTask(){

            @Override
            public void run() {
                timeout.executeTask();
            }
        };
        timeout.setTaskRef(taskRef);
        this.jtimer.schedule(taskRef, delayInMills);
        return timeout;
    }

    @Override
    public Set<Timeout> stop() {
        this.jtimer.cancel();
        this.running = false;
        return Collects.emptyHashSet();
    }
}

