/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Fiat {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ORDERS = "/sapi/v1/fiat/orders";
    private final String PAYMENTS = "/sapi/v1/fiat/payments";

    public Fiat(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Fiat(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String orders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "transactionType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/fiat/orders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String payments(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "transactionType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/fiat/payments", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

