/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.ClasspathHelper;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class DotenvReader {
    private final String directory;
    private final String filename;

    public DotenvReader(String directory, String filename) {
        this.directory = directory;
        this.filename = filename;
    }

    public List<String> read() throws DotenvException, IOException {
        Path path;
        String dir = this.directory.replaceAll("\\\\", "/").replaceFirst("\\.env$", "").replaceFirst("/$", "");
        String location = dir + "/" + this.filename;
        String lowerLocation = location.toLowerCase();
        Path path2 = path = lowerLocation.startsWith("file:") || lowerLocation.startsWith("android.resource:") || lowerLocation.startsWith("jimfs:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.readAllLines(path);
        }
        try {
            return ClasspathHelper.loadFileFromClasspath(location.replaceFirst("^\\./", "/")).collect(Collectors.toList());
        }
        catch (DotenvException e) {
            Path cwd = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath().normalize();
            String cwdMessage = !path.isAbsolute() ? "(working directory: " + String.valueOf(cwd) + ")" : "";
            e.addSuppressed(new DotenvException("Could not find " + String.valueOf(path) + " on the file system " + cwdMessage));
            throw e;
        }
    }
}

