/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.metrics;

import io.github.icodegarden.commons.lang.NamedObject;
import io.github.icodegarden.commons.lang.util.SystemUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class Metrics
implements NamedObject,
Comparable<Metrics>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String instanceName;
    private Map<DimensionName, Dimension> dimensions = new HashMap<DimensionName, Dimension>(4, 1.0f);
    private String desc;

    Metrics() {
    }

    public Metrics(Dimension d, Dimension ... dimensions) {
        if (d == null) {
            throw new IllegalArgumentException("param notnull must not null");
        }
        this.setDimension(d);
        for (Dimension dimension : dimensions) {
            this.setDimension(dimension);
        }
    }

    public Metrics(List<Dimension> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            throw new IllegalArgumentException("param dimensions must not empty");
        }
        dimensions.forEach(dimension -> this.setDimension((Dimension)dimension));
    }

    @Override
    public String name() {
        return this.getServiceName();
    }

    public void setDimension(Dimension dimension) {
        this.dimensions.put(dimension.getDimensionName(), dimension);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Map<DimensionName, Dimension> getDimensions() {
        return this.dimensions;
    }

    public Dimension getDimension(DimensionName dimensionName) {
        return this.dimensions.get(dimensionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incrementDimension(DimensionName dimensionName, double value) {
        Dimension dimension = this.getDimension(dimensionName);
        if (dimension != null) {
            Dimension dimension2 = dimension;
            synchronized (dimension2) {
                dimension.setUsed(dimension.getUsed() + value);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementDimension(DimensionName dimensionName, double value) {
        Dimension dimension = this.getDimension(dimensionName);
        if (dimension != null) {
            Dimension dimension2 = dimension;
            synchronized (dimension2) {
                dimension.setUsed(dimension.getUsed() - value);
                if (dimension.getUsed() < 0.0) {
                    dimension.setUsed(0.0);
                }
            }
            return true;
        }
        return false;
    }

    public void refreshUsedValues() {
        Dimension memoryD;
        Dimension cpuD = this.getDimension(DimensionName.Cpu);
        if (cpuD != null) {
            cpuD.setUsed(SystemUtils.getVmRuntime().getProcessCpuLoad());
        }
        if ((memoryD = this.getDimension(DimensionName.Memory)) != null) {
            memoryD.setUsed(SystemUtils.getVmRuntime().getJvmUsedMemory() / 1024L / 1024L);
        }
    }

    public boolean isOverload() {
        for (Dimension dimension : this.dimensions.values()) {
            if (dimension.getWeight() <= 0 || !(dimension.getUsed() >= dimension.getMax())) continue;
            return true;
        }
        return false;
    }

    public List<Dimension> overloadDimensions() {
        return this.dimensions.values().stream().filter(dimension -> dimension.getUsed() >= dimension.getMax()).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metrics other = (Metrics)obj;
        return !(this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName));
    }

    public String toString() {
        return "[instanceName=" + this.instanceName + ", dimensions=" + this.dimensions + "]";
    }

    @Override
    public int compareTo(Metrics other) {
        if (other == null) {
            return -1;
        }
        Map<DimensionName, Dimension> thisDimensions = this.getDimensions();
        Map<DimensionName, Dimension> otherDimensions = other.getDimensions();
        AtomicReference<Double> minus = new AtomicReference<Double>(0.0);
        thisDimensions.forEach((thisName, thisDimension) -> {
            Dimension otherDimension = (Dimension)otherDimensions.get(thisName);
            double thisRemainRate = 0.0;
            double otherRemainRate = 0.0;
            if (otherDimension == null) {
                thisRemainRate = (thisDimension.getMax() - thisDimension.getUsed()) / thisDimension.getMax();
                thisRemainRate *= (double)thisDimension.getWeight();
            } else {
                thisRemainRate = (thisDimension.getMax() - thisDimension.getUsed()) / thisDimension.getMax();
                thisRemainRate *= (double)thisDimension.getWeight();
                otherRemainRate = (otherDimension.getMax() - otherDimension.getUsed()) / otherDimension.getMax();
                otherRemainRate *= (double)otherDimension.getWeight();
            }
            minus.set((Double)minus.get() + thisRemainRate - otherRemainRate);
        });
        if (minus.get() == 0.0) {
            return 0;
        }
        return minus.get() > 0.0 ? -1 : 1;
    }

    public static class Dimension
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DimensionName dimensionName;
        private double max;
        private double used;
        private int weight;
        private String desc;

        Dimension() {
        }

        public Dimension(DimensionName dimensionName, double max, double used) {
            this(dimensionName, max, used, 1);
        }

        public Dimension(DimensionName dimensionName, double max, double used, int weight) {
            if (weight < 0 || weight > 100) {
                throw new IllegalArgumentException("weight must range [0-100]");
            }
            this.dimensionName = dimensionName;
            this.max = max;
            this.used = used;
            this.weight = weight;
        }

        public DimensionName getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(DimensionName dimensionName) {
            this.dimensionName = dimensionName;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public double getUsed() {
            return this.used;
        }

        public void setUsed(double used) {
            this.used = used;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return "Dimension [dimensionName=" + this.dimensionName + ", max=" + this.max + ", used=" + this.used + ", weight=" + this.weight + ", desc=" + this.desc + "]";
        }
    }

    public static class DimensionName
    implements Serializable {
        private static final long serialVersionUID = 6468102993100427298L;
        public static final DimensionName Cpu = new DimensionName("cpu");
        public static final DimensionName Memory = new DimensionName("memory");
        public static final DimensionName Jobs = new DimensionName("jobs");
        private final String value;

        DimensionName() {
            this.value = null;
        }

        public DimensionName(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionName other = (DimensionName)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "DimensionName [value=" + this.value + "]";
        }
    }
}

