/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.query;

import io.github.icodegarden.commons.lang.query.TableDataCountCollector;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractTableDataCountCollector
implements TableDataCountCollector {
    private final Set<String> whiteListTables;
    private List<String> listTablesCache;

    public AbstractTableDataCountCollector() {
        this(null);
    }

    public AbstractTableDataCountCollector(Set<String> whiteListTables) {
        this.whiteListTables = whiteListTables;
    }

    @Override
    public List<String> listTables() {
        if (this.listTablesCache == null) {
            List<String> list = this.doListTables();
            if (this.whiteListTables != null) {
                list = this.doListTables().stream().filter(table -> this.whiteListTables.contains(table)).collect(Collectors.toList());
            }
            this.listTablesCache = list;
        }
        return this.listTablesCache;
    }

    protected abstract List<String> doListTables();
}

