/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.query;

import io.github.icodegarden.commons.lang.query.DuplicateKeyException;
import io.github.icodegarden.commons.lang.query.TableDataCountCollector;
import io.github.icodegarden.commons.lang.query.TableDataCountPO;
import io.github.icodegarden.commons.lang.query.TableDataCountStorage;
import io.github.icodegarden.commons.lang.util.SystemUtils;
import io.github.icodegarden.commons.lang.util.ThreadPoolUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataCountManager {
    private static final Logger log = LoggerFactory.getLogger(TableDataCountManager.class);
    public static final int DEFAULT_ALLOW_COUNT_THRESHOLD = 500000;
    private Map<String, Long> cache;
    private final TableDataCountCollector tableCountCollector;
    private final TableDataCountStorage tableCountStorage;
    private long allowCountThreshold;
    private ScheduledFuture<?> future;

    public TableDataCountManager(TableDataCountCollector tableCountCollector, TableDataCountStorage tableCountStorage) {
        this(tableCountCollector, tableCountStorage, 500000L);
    }

    public TableDataCountManager(TableDataCountCollector tableCountCollector, TableDataCountStorage tableCountStorage, long allowCountThreshold) {
        this.tableCountCollector = tableCountCollector;
        this.tableCountStorage = tableCountStorage;
        this.allowCountThreshold = allowCountThreshold;
    }

    public boolean allowCount(String tableName) {
        if (this.future == null) {
            throw new IllegalStateException("schedule is not start, please start it before this.");
        }
        this.refreshCacheIfNull();
        Long count = this.cache.get(tableName);
        if (count == null) {
            return true;
        }
        return count < this.allowCountThreshold;
    }

    public void start(long initialDelayMillis, long scheduleMillis) {
        ScheduledThreadPoolExecutor scheduledThreadPool = ThreadPoolUtils.newSingleScheduledThreadPool("TableDataCount-Schedule");
        this.future = scheduledThreadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doSchedule();
            }
            catch (Exception e) {
                log.error("WARN ex on refreshCache", (Throwable)e);
            }
        }, initialDelayMillis, scheduleMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.future.cancel(false);
        this.future = null;
    }

    private void doSchedule() {
        List<String> tables = this.tableCountCollector.listTables();
        this.refreshCacheIfNull();
        for (String table : tables) {
            Long tableCount = this.cache.get(table);
            if (tableCount == null) {
                try {
                    this.create(table);
                }
                catch (DuplicateKeyException ignore) {
                    log.info("duplicate table name:{} on table", (Object)table);
                }
                tableCount = 0L;
            }
            if (tableCount >= this.allowCountThreshold) continue;
            long count = this.tableCountCollector.countTable(table);
            this.tableCountStorage.updateCount(table, count);
            this.cache.put(table, count);
        }
    }

    private void refreshCacheIfNull() {
        if (this.cache == null) {
            List<TableDataCountPO> list = this.tableCountStorage.findAll();
            this.cache = list.stream().collect(Collectors.toMap(TableDataCountPO::getTableName, TableDataCountPO::getDataCount));
        }
    }

    private void create(String tableName) {
        TableDataCountPO po = new TableDataCountPO();
        po.setTableName(tableName);
        po.setUpdatedAt(SystemUtils.now());
        po.setDataCount(0L);
        this.tableCountStorage.add(po);
    }
}

