/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.registry;

import io.github.icodegarden.commons.lang.annotation.Nullable;
import io.github.icodegarden.commons.lang.registry.RegisteredInstance;

public class DefaultRegisteredInstance
implements RegisteredInstance {
    private String serviceName;
    private String instanceName;
    private String scheme;
    private String ip;
    private int port;

    public DefaultRegisteredInstance(String serviceName, String instanceName, String ip, int port) {
        this(serviceName, instanceName, null, ip, port);
    }

    public DefaultRegisteredInstance(String serviceName, String instanceName, @Nullable String scheme, String ip, int port) {
        this.serviceName = serviceName;
        this.instanceName = instanceName;
        this.scheme = scheme;
        this.ip = ip;
        this.port = port;
    }

    @Override
    public String name() {
        return this.getServiceName();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRegisteredInstance other = (DefaultRegisteredInstance)obj;
        if (this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
    }

    public String toString() {
        return "Default [serviceName=" + this.serviceName + ", instanceName=" + this.instanceName + ", scheme=" + this.scheme + ", ip=" + this.ip + ", port=" + this.port + "]";
    }
}

