/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.schedule;

import io.github.icodegarden.commons.lang.schedule.Schedule;
import io.github.icodegarden.commons.lang.util.CronUtils;
import io.github.icodegarden.commons.lang.util.ThreadPoolUtils;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractSchedule
implements Schedule {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchedule.class);
    private final ScheduledThreadPoolExecutor scheduleThreadPool = ThreadPoolUtils.newSingleScheduledThreadPool(this.getClass().getSimpleName());
    private long loop;
    private long logmod;
    private final AtomicBoolean started;
    private final AtomicBoolean closed;
    private ScheduledFuture<?> future;

    public AbstractSchedule() {
        this.scheduleThreadPool.setRemoveOnCancelPolicy(true);
        this.logmod = 100L;
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public boolean scheduleWithFixedDelay(long initialDelayMillis, long scheduleMillis) {
        if (this.started.compareAndSet(false, true)) {
            this.future = this.scheduleThreadPool.scheduleWithFixedDelay(() -> this.scheduling(), initialDelayMillis, scheduleMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public boolean scheduleAtFixedRate(long initialDelayMillis, long scheduleMillis) {
        if (this.started.compareAndSet(false, true)) {
            this.future = this.scheduleThreadPool.scheduleAtFixedRate(() -> this.scheduling(), initialDelayMillis, scheduleMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public boolean scheduleWithCron(String cron) {
        Assert.isTrue((boolean)CronUtils.isValid(cron), (String)"Invalid:cron");
        if (this.started.compareAndSet(false, true)) {
            this.doCron(cron);
            return true;
        }
        return false;
    }

    private void doCron(String cron) {
        this.future = this.scheduleThreadPool.schedule(() -> {
            this.scheduling();
            this.doCron(cron);
        }, CronUtils.nextDelayMillis(cron), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduling() {
        AbstractSchedule abstractSchedule = this;
        synchronized (abstractSchedule) {
            try {
                if (log.isInfoEnabled() && this.allowLoopLog()) {
                    log.info("{} schedule run, loop:{}", (Object)this.getClass().getSimpleName(), (Object)this.loop);
                }
                if (this.isClosed()) {
                    log.info("{} schedule was closed, stop", (Object)this.getClass().getSimpleName());
                    return;
                }
                this.doSchedule();
            }
            catch (Throwable e) {
                log.warn("ex on {}", (Object)this.getClass().getSimpleName(), (Object)e);
            }
            finally {
                ++this.loop;
            }
        }
    }

    protected abstract void doSchedule() throws Throwable;

    public void setLogmod(long logmod) {
        this.logmod = logmod;
    }

    protected boolean allowLoopLog() {
        return this.loop % this.logmod == 0L;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.closed.set(true);
        AbstractSchedule abstractSchedule = this;
        synchronized (abstractSchedule) {
        }
    }
}

