/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import io.github.icodegarden.commons.lang.serialization.Deserializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class JavaDeserializer
implements Deserializer<Object> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException("Error when deserializing byte[] to object", e);
        }
    }
}

