/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import io.github.icodegarden.commons.lang.serialization.Deserializer;
import io.github.icodegarden.commons.lang.serialization.KryoSerializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class KryoDeserializer
implements Deserializer<Object> {
    private static KryoSerializer.AbstractKryoFactory kryoFactory = new KryoSerializer.ThreadLocalKryoFactory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        Kryo kryo = kryoFactory.getKryo();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try (Input input = new Input((InputStream)byteArrayInputStream);){
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        catch (KryoException e) {
            throw new SerializationException("Error when deserializing byte[] to object", e);
        }
    }
}

