/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.spec.response;

import io.github.icodegarden.commons.lang.spec.response.ClientBizErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ClientLimitedErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ClientParameterInvalidErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ClientParameterMissingErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ClientPermissionErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ErrorCodeException;
import io.github.icodegarden.commons.lang.spec.response.ServerErrorCodeException;
import java.util.Objects;

public class ApiResponse {
    public static final String CODE_SUCCESS = "10000";
    public static final String MSG_SUCCESS = "Success";
    private String code;
    private String msg;
    private String sub_code;
    private String sub_msg;

    public boolean isSuccess() {
        return CODE_SUCCESS.equals(this.code);
    }

    public ErrorCodeException toErrorCodeException() {
        if ("40004".equals(this.code)) {
            if (ClientBizErrorCodeException.SubCode.FORBIDDEN.getSub_code().equals(this.sub_code)) {
                return new ClientBizErrorCodeException(ClientBizErrorCodeException.SubCode.FORBIDDEN, this.sub_msg);
            }
            if (ClientBizErrorCodeException.SubCode.NOT_FOUND.getSub_code().equals(this.sub_code)) {
                return new ClientBizErrorCodeException(ClientBizErrorCodeException.SubCode.NOT_FOUND, this.sub_msg);
            }
            if (ClientBizErrorCodeException.SubCode.CONFLICT.getSub_code().equals(this.sub_code)) {
                return new ClientBizErrorCodeException(ClientBizErrorCodeException.SubCode.CONFLICT, this.sub_msg);
            }
            return new ClientBizErrorCodeException(this.sub_code, this.sub_msg);
        }
        if ("40005".equals(this.code)) {
            return new ClientLimitedErrorCodeException(this.sub_code, this.sub_msg);
        }
        if ("40002".equals(this.code)) {
            return new ClientParameterInvalidErrorCodeException(this.sub_code, this.sub_msg);
        }
        if ("40001".equals(this.code)) {
            return new ClientParameterMissingErrorCodeException(this.sub_code, this.sub_msg);
        }
        if ("40006".equals(this.code)) {
            return new ClientPermissionErrorCodeException(this.sub_code, this.sub_msg);
        }
        if ("20000".equals(this.code)) {
            return new ServerErrorCodeException(this.sub_code, this.sub_msg);
        }
        return new ErrorCodeExceptionImpl();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSub_code() {
        return this.sub_code;
    }

    public void setSub_code(String sub_code) {
        this.sub_code = sub_code;
    }

    public String getSub_msg() {
        return this.sub_msg;
    }

    public void setSub_msg(String sub_msg) {
        this.sub_msg = sub_msg;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.msg, this.sub_code, this.sub_msg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiResponse other = (ApiResponse)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.msg, other.msg) && Objects.equals(this.sub_code, other.sub_code) && Objects.equals(this.sub_msg, other.sub_msg);
    }

    public String toString() {
        return "ApiResponse [code=" + this.code + ", msg=" + this.msg + ", sub_code=" + this.sub_code + ", sub_msg=" + this.sub_msg + "]";
    }

    private class ErrorCodeExceptionImpl
    extends ErrorCodeException {
        private static final long serialVersionUID = 1L;

        public ErrorCodeExceptionImpl() {
            super(ApiResponse.this.code, ApiResponse.this.msg, ApiResponse.this.sub_code, ApiResponse.this.sub_msg);
        }

        @Override
        public int httpStatus() {
            return -1;
        }
    }
}

