/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.spec.response;

import io.github.icodegarden.commons.lang.util.JsonUtils;

public abstract class ErrorCodeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String msg;
    private final String sub_code;
    private final String sub_msg;
    private Object reference;

    public ErrorCodeException(String code, String msg, String sub_code, String sub_msg) {
        this.code = code;
        this.msg = msg;
        this.sub_code = sub_code;
        this.sub_msg = sub_msg;
    }

    public ErrorCodeException(String code, String msg, String sub_code, String sub_msg, Throwable cause) {
        super(cause);
        this.code = code;
        this.msg = msg;
        this.sub_code = sub_code;
        this.sub_msg = sub_msg;
    }

    public ErrorCodeException(String code, String msg, String sub_code, String sub_msg, Throwable cause, Object reference) {
        super(cause);
        this.code = code;
        this.msg = msg;
        this.sub_code = sub_code;
        this.sub_msg = sub_msg;
        this.reference = reference;
    }

    public abstract int httpStatus();

    @Override
    public String getMessage() {
        Json json = new Json(this);
        return JsonUtils.serialize(json);
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getSub_code() {
        return this.sub_code;
    }

    public String getSub_msg() {
        return this.sub_msg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + (this.sub_code == null ? 0 : this.sub_code.hashCode());
        result = 31 * result + (this.sub_msg == null ? 0 : this.sub_msg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorCodeException other = (ErrorCodeException)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.msg == null ? other.msg != null : !this.msg.equals(other.msg)) {
            return false;
        }
        if (this.sub_code == null ? other.sub_code != null : !this.sub_code.equals(other.sub_code)) {
            return false;
        }
        return !(this.sub_msg == null ? other.sub_msg != null : !this.sub_msg.equals(other.sub_msg));
    }

    private class Json {
        private final String code;
        private final String msg;
        private final String sub_code;
        private final String sub_msg;

        public Json(ErrorCodeException ece) {
            this.code = ece.code;
            this.msg = ece.msg;
            this.sub_code = ece.sub_code;
            this.sub_msg = ece.sub_msg;
        }

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getSub_code() {
            return this.sub_code;
        }

        public String getSub_msg() {
            return this.sub_msg;
        }
    }
}

