/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class AESUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    private static byte[] getSecretKey(String randomKey) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        if (randomKey == null) {
            keyGenerator.init(128);
        } else {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(randomKey.getBytes());
            keyGenerator.init(128, random);
        }
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    private static byte[] encrypt(byte[] data, Key key) throws Exception {
        return AESUtils.encrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
    }

    private static byte[] encrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(byte[] data, Key key) throws Exception {
        return AESUtils.decrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
    }

    private static byte[] decrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    private static Key toKey(byte[] secretKey) {
        return new SecretKeySpec(secretKey, KEY_ALGORITHM);
    }

    public static String encrypt(String data, String aeskey) {
        try {
            byte[] secretKey = AESUtils.getSecretKey(aeskey);
            Key key = AESUtils.toKey(secretKey);
            byte[] encryptData = AESUtils.encrypt(data.getBytes("utf-8"), key);
            String encryptHex = Hex.encodeHexString((byte[])encryptData);
            return encryptHex;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decrypt(String encryptHex, String aeskey) {
        try {
            byte[] secretKey2 = AESUtils.getSecretKey(aeskey);
            Key key2 = AESUtils.toKey(secretKey2);
            byte[] strBytes = AESUtils.decrypt(Hex.decodeHex((String)encryptHex), key2);
            return new String(strBytes, "utf-8");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

