/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CollectionUtils {
    public static <T> List<T> nextElements(List<T> elements, int fromIndex, int maxNum) {
        fromIndex = fromIndex < 0 ? 0 : fromIndex;
        if ((fromIndex = Math.min(fromIndex, elements.size())) + (maxNum = Math.min(maxNum, elements.size())) <= elements.size()) {
            return elements.subList(fromIndex, fromIndex + maxNum);
        }
        List<T> subList1 = elements.subList(fromIndex, elements.size());
        if (subList1.size() == maxNum) {
            return subList1;
        }
        List<T> subList2 = elements.subList(0, maxNum - (elements.size() - fromIndex));
        ArrayList<T> arrayList = new ArrayList<T>(maxNum);
        arrayList.addAll(subList1);
        arrayList.addAll(subList2);
        return arrayList;
    }

    public static <T> List<T> subSafely(List<T> elements, int fromIndex, int maxNum) {
        fromIndex = fromIndex < 0 ? 0 : fromIndex;
        if ((fromIndex = Math.min(fromIndex, elements.size())) + (maxNum = Math.min(maxNum, elements.size())) <= elements.size()) {
            return elements.subList(fromIndex, fromIndex + maxNum);
        }
        return elements.subList(fromIndex, elements.size());
    }

    public static byte[][] toBytesArray(Collection<String> values) {
        List vBytes = values.stream().map(v -> v.getBytes()).collect(Collectors.toList());
        byte[][] vBytesArray = (byte[][])vBytes.toArray((T[])new byte[vBytes.size()][]);
        return vBytesArray;
    }
}

