/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.algorithm.consistenthash;

import io.github.icodegarden.commons.lang.algorithm.HashFunction;
import io.github.icodegarden.commons.lang.algorithm.MD5Function;
import io.github.icodegarden.commons.lang.algorithm.consistenthash.Node;
import io.github.icodegarden.commons.lang.algorithm.consistenthash.VirtualNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashRouter<T extends Node> {
    private final SortedMap<Number, VirtualNode<T>> ring = new TreeMap<Number, VirtualNode<T>>();
    private final HashFunction hashFunc;

    public ConsistentHashRouter(Collection<T> pNodes, int vNodeCount) {
        this(pNodes, vNodeCount, new MD5Function());
    }

    public ConsistentHashRouter(Collection<T> pNodes, int vNodeCount, HashFunction hashFunc) {
        this.hashFunc = hashFunc;
        if (pNodes != null) {
            for (Node pNode : pNodes) {
                this.addOrUpdatePhysicalNode(pNode, vNodeCount);
            }
        }
    }

    public void addOrUpdatePhysicalNode(T pNode, int vNodeCount) {
        if (vNodeCount < 0) {
            throw new IllegalArgumentException("illegal virtual node counts :" + vNodeCount);
        }
        int existingCount = this.countExistingVirtualNodes(pNode);
        for (int i = 0; i < vNodeCount; ++i) {
            VirtualNode<T> vNode = new VirtualNode<T>(pNode, i + existingCount);
            this.ring.put(this.hashFunc.hash(vNode.getKey()), vNode);
        }
    }

    public void removePhysicalNode(T pNode) {
        Iterator<Map.Entry<Number, VirtualNode<T>>> it = this.ring.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Number, VirtualNode<T>> next = it.next();
            VirtualNode<T> virtualNode = next.getValue();
            if (!virtualNode.isVirtualNodeOf(pNode)) continue;
            it.remove();
        }
    }

    public VirtualNode<T> routeNode(String key) {
        if (this.ring.isEmpty()) {
            return null;
        }
        Integer hashVal = this.hashFunc.hash(key);
        SortedMap<Number, VirtualNode<T>> tailMap = this.ring.tailMap(hashVal);
        Number nodeHashVal = !tailMap.isEmpty() ? (Number)tailMap.firstKey() : (Number)this.ring.firstKey();
        return (VirtualNode)this.ring.get(nodeHashVal);
    }

    public int countExistingVirtualNodes(T pNode) {
        int count = 0;
        for (VirtualNode<T> vNode : this.ring.values()) {
            if (!vNode.isVirtualNodeOf(pNode)) continue;
            ++count;
        }
        return count;
    }

    public int countExistingVirtualNodes() {
        return this.ring.size();
    }
}

