/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.algorithm.consistenthash;

import io.github.icodegarden.commons.lang.algorithm.consistenthash.Node;
import java.util.Objects;

public class VirtualNode<T extends Node>
implements Node {
    private final T physicalNode;
    private final int number;

    public VirtualNode(T physicalNode, int number) {
        this.number = number;
        this.physicalNode = physicalNode;
    }

    @Override
    public String getKey() {
        return this.physicalNode.getKey() + "-" + this.number;
    }

    public boolean isVirtualNodeOf(T pNode) {
        return this.physicalNode.getKey().equals(pNode.getKey());
    }

    public T getPhysicalNode() {
        return this.physicalNode;
    }

    public int hashCode() {
        return Objects.hash(this.number, this.physicalNode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualNode other = (VirtualNode)obj;
        return this.number == other.number && Objects.equals(this.physicalNode, other.physicalNode);
    }

    public String toString() {
        return "VirtualNode [number=" + this.number + "]";
    }
}

