/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.limiter;

import io.github.icodegarden.commons.lang.limiter.RateLimiter;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakyBucketRateLimiter
implements RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(LeakyBucketRateLimiter.class);
    private int bucketSize;
    private int outflowSize;
    private Duration outflowDuration;
    private long lastResetTime = System.currentTimeMillis();
    private AtomicInteger token;

    public LeakyBucketRateLimiter(int bucketSize, int outflowSize, Duration outflowDuration) {
        this.token = new AtomicInteger(bucketSize);
        this.bucketSize = bucketSize;
        this.outflowSize = outflowSize;
        this.outflowDuration = outflowDuration;
    }

    private void reset() {
        long now = System.currentTimeMillis();
        long cost = now - this.lastResetTime;
        double rate = (double)cost * 1.0 / (double)this.outflowDuration.toMillis();
        int shouldOutflow = (int)((double)this.outflowSize * rate);
        System.out.println("shouldOutflow=" + shouldOutflow);
        if (shouldOutflow == 0) {
            return;
        }
        this.token.updateAndGet(pre -> {
            int v = pre + shouldOutflow;
            return v <= this.bucketSize ? v : this.bucketSize;
        });
        this.lastResetTime = System.currentTimeMillis();
    }

    @Override
    public boolean isAllowable(int weight) {
        if (this.token.intValue() < weight) {
            this.reset();
        }
        if (this.token.intValue() < weight) {
            if (log.isInfoEnabled()) {
                log.info("{}:{} not allowed", (Object)LeakyBucketRateLimiter.class.getSimpleName(), (Object)this.getName());
            }
            return false;
        }
        this.token.addAndGet(-weight);
        return true;
    }
}

