/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.BitSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.RegexSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.URISerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import io.github.icodegarden.commons.lang.serialization.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class KryoSerializer
implements Serializer<Object> {
    private static AbstractKryoFactory kryoFactory = new ThreadLocalKryoFactory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object obj) throws SerializationException {
        Kryo kryo = kryoFactory.getKryo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        try (Output output = new Output((OutputStream)byteArrayOutputStream);){
            kryo.writeClassAndObject(output, obj);
            output.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (KryoException e) {
            throw new SerializationException("Error when serializing object to byte[]", e);
        }
    }

    static class ThreadLocalKryoFactory
    extends AbstractKryoFactory {
        private final ThreadLocal<Kryo> holder = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                return this.create();
            }
        };

        ThreadLocalKryoFactory() {
        }

        @Override
        public void returnKryo(Kryo kryo) {
        }

        @Override
        public Kryo getKryo() {
            return this.holder.get();
        }
    }

    public static abstract class AbstractKryoFactory {
        private static Consumer<Kryo> kryoFactoryCustom;
        private final Set<Class> registrations = new LinkedHashSet<Class>();
        private boolean registrationRequired;
        private volatile boolean kryoCreated;

        public static void configKryoFactoryCustom(Consumer<Kryo> kryoFactoryCustom) {
            AbstractKryoFactory.kryoFactoryCustom = kryoFactoryCustom;
        }

        public void registerClass(Class clazz) {
            if (this.kryoCreated) {
                throw new IllegalStateException("Can't register class after creating kryo instance");
            }
            this.registrations.add(clazz);
        }

        public Kryo create() {
            if (!this.kryoCreated) {
                this.kryoCreated = true;
            }
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(this.registrationRequired);
            kryo.addDefaultSerializer(Throwable.class, (com.esotericsoftware.kryo.Serializer)new JavaSerializer());
            kryo.register(Arrays.asList("").getClass(), (com.esotericsoftware.kryo.Serializer)new ArraysAsListSerializer());
            kryo.register(GregorianCalendar.class, (com.esotericsoftware.kryo.Serializer)new GregorianCalendarSerializer());
            kryo.register(InvocationHandler.class, (com.esotericsoftware.kryo.Serializer)new JdkProxySerializer());
            kryo.register(BigDecimal.class, (com.esotericsoftware.kryo.Serializer)new DefaultSerializers.BigDecimalSerializer());
            kryo.register(BigInteger.class, (com.esotericsoftware.kryo.Serializer)new DefaultSerializers.BigIntegerSerializer());
            kryo.register(Pattern.class, (com.esotericsoftware.kryo.Serializer)new RegexSerializer());
            kryo.register(BitSet.class, (com.esotericsoftware.kryo.Serializer)new BitSetSerializer());
            kryo.register(URI.class, (com.esotericsoftware.kryo.Serializer)new URISerializer());
            kryo.register(UUID.class, (com.esotericsoftware.kryo.Serializer)new UUIDSerializer());
            UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
            SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
            kryo.register(HashMap.class);
            kryo.register(ArrayList.class);
            kryo.register(LinkedList.class);
            kryo.register(HashSet.class);
            kryo.register(TreeSet.class);
            kryo.register(Hashtable.class);
            kryo.register(Date.class);
            kryo.register(Calendar.class);
            kryo.register(ConcurrentHashMap.class);
            kryo.register(SimpleDateFormat.class);
            kryo.register(GregorianCalendar.class);
            kryo.register(Vector.class);
            kryo.register(BitSet.class);
            kryo.register(StringBuffer.class);
            kryo.register(StringBuilder.class);
            kryo.register(Object.class);
            kryo.register(Object[].class);
            kryo.register(String[].class);
            kryo.register(byte[].class);
            kryo.register(char[].class);
            kryo.register(int[].class);
            kryo.register(float[].class);
            kryo.register(double[].class);
            kryo.register(double[].class);
            for (Class clazz : this.registrations) {
                kryo.register(clazz);
            }
            if (kryoFactoryCustom != null) {
                kryoFactoryCustom.accept(kryo);
            }
            return kryo;
        }

        public void setRegistrationRequired(boolean registrationRequired) {
            this.registrationRequired = registrationRequired;
        }

        public abstract void returnKryo(Kryo var1);

        public abstract Kryo getKryo();
    }
}

