/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.spec.sign;

import io.github.icodegarden.commons.lang.annotation.Nullable;
import io.github.icodegarden.commons.lang.spec.response.OpenApiResponse;
import io.github.icodegarden.commons.lang.spec.sign.OpenApiRequestBody;

abstract class BaseSignUtils {
    BaseSignUtils() {
    }

    protected static String buildRequestSignParams(OpenApiRequestBody body, @Nullable String appKey) {
        StringBuilder sb = new StringBuilder("app_id=").append(body.getApp_id());
        if (BaseSignUtils.hasText(body.getBiz_content())) {
            sb.append("&biz_content=").append(body.getBiz_content());
        }
        if (BaseSignUtils.hasText(body.getCharset())) {
            sb.append("&charset=").append(body.getCharset());
        }
        if (BaseSignUtils.hasText(body.getFormat())) {
            sb.append("&format=").append(body.getFormat());
        }
        if (BaseSignUtils.hasText(body.getMethod())) {
            sb.append("&method=").append(body.getMethod());
        }
        if (BaseSignUtils.hasText(body.getRequest_id())) {
            sb.append("&request_id=").append(body.getRequest_id());
        }
        if (BaseSignUtils.hasText(body.getSign_type())) {
            sb.append("&sign_type=").append(body.getSign_type());
        }
        if (BaseSignUtils.hasText(body.getTimestamp())) {
            sb.append("&timestamp=").append(body.getTimestamp());
        }
        if (BaseSignUtils.hasText(body.getVersion())) {
            sb.append("&version=").append(body.getVersion());
        }
        if (BaseSignUtils.hasText(appKey)) {
            sb.append("&key=").append(appKey);
        }
        return sb.toString();
    }

    protected static boolean hasText(String str) {
        return str != null && !str.isEmpty();
    }

    protected static String buildResponseSignParams(OpenApiResponse body, String appKey) {
        StringBuilder sb = new StringBuilder("biz_content=").append(body.getBiz_content());
        sb.append("&key=").append(appKey);
        return sb.toString();
    }
}

