/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.spec.sign;

import io.github.icodegarden.commons.lang.spec.response.OpenApiResponse;
import io.github.icodegarden.commons.lang.spec.sign.BaseSignUtils;
import io.github.icodegarden.commons.lang.spec.sign.OpenApiRequestBody;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASignUtils
extends BaseSignUtils {
    private static final Logger log = LoggerFactory.getLogger(RSASignUtils.class);
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";

    public static boolean supports(String signType) {
        try {
            SignType.valueOf(signType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String requestSign(OpenApiRequestBody body, String privateKey) {
        String buildSignParams = RSASignUtils.buildRequestSignParams(body, null);
        if (log.isDebugEnabled()) {
            log.debug("request params to sign:{}", (Object)buildSignParams);
        }
        String sign_type = body.getSign_type();
        String charset = body.getCharset();
        try {
            return RSASignUtils.doSign(privateKey, buildSignParams, sign_type, charset);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean validateRequestSign(OpenApiRequestBody body, String publicKey) {
        String buildSignParams = RSASignUtils.buildRequestSignParams(body, null);
        String sign_type = body.getSign_type();
        String charset = body.getCharset();
        String sign = body.getSign();
        try {
            return RSASignUtils.doValidate(publicKey, buildSignParams, sign_type, charset, sign);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String responseSign(OpenApiResponse body, String sign_type, String privateKey) {
        return RSASignUtils.responseSign(body, sign_type, "UTF-8", privateKey);
    }

    public static String responseSign(OpenApiResponse body, String sign_type, String charset, String privateKey) {
        String buildSignParams = RSASignUtils.buildResponseSignParams(body);
        if (log.isDebugEnabled()) {
            log.debug("response params to sign:{}", (Object)buildSignParams);
        }
        try {
            return RSASignUtils.doSign(privateKey, buildSignParams, sign_type, charset);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean validateResponseSign(OpenApiResponse body, String sign_type, String charset, String publicKey) {
        String buildSignParams = RSASignUtils.buildResponseSignParams(body);
        String sign = body.getSign();
        try {
            return RSASignUtils.doValidate(publicKey, buildSignParams, sign_type, charset, sign);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String doSign(String privateKey, String buildSignParams, String sign_type, String charset) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException, InvalidKeySpecException {
        PrivateKey priKey = null;
        Signature signature = null;
        if (SignType.RSA.name().equals(sign_type)) {
            priKey = RSASignUtils.getPrivateKeyFromPKCS8(SignType.RSA.name(), privateKey);
            signature = Signature.getInstance(SIGN_ALGORITHMS);
        } else if (SignType.RSA2.name().equals(sign_type)) {
            priKey = RSASignUtils.getPrivateKeyFromPKCS8(SignType.RSA.name(), privateKey);
            signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
        } else {
            throw new IllegalArgumentException("\u4e0d\u662f\u652f\u6301\u7684\u7b7e\u540d\u7c7b\u578b : : signType=" + sign_type);
        }
        signature.initSign(priKey);
        if (RSASignUtils.hasText(charset)) {
            signature.update(buildSignParams.getBytes(charset));
        } else {
            signature.update(buildSignParams.getBytes());
        }
        byte[] signed = signature.sign();
        return new String(Base64.getEncoder().encode(signed));
    }

    private static boolean doValidate(String publicKey, String buildSignParams, String sign_type, String charset, String sign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException, InvalidKeySpecException {
        Signature signature = null;
        PublicKey pubKey = RSASignUtils.getPublicKeyFromX509("RSA", publicKey);
        if (SignType.RSA.name().equals(sign_type)) {
            signature = Signature.getInstance(SIGN_ALGORITHMS);
        } else if (SignType.RSA2.name().equals(sign_type)) {
            signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
        } else {
            throw new IllegalArgumentException("\u4e0d\u662f\u652f\u6301\u7684\u7b7e\u540d\u7c7b\u578b : signType=" + sign_type);
        }
        signature.initVerify(pubKey);
        if (RSASignUtils.hasText(charset)) {
            signature.update(buildSignParams.getBytes(charset));
        } else {
            signature.update(buildSignParams.getBytes());
        }
        return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
    }

    private static String buildResponseSignParams(OpenApiResponse body) {
        StringBuilder sb = new StringBuilder("biz_content=").append(body.getBiz_content());
        return sb.toString();
    }

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = Base64.getDecoder().decode(privateKey.getBytes());
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    private static PublicKey getPublicKeyFromX509(String algorithm, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = Base64.getDecoder().decode(publicKey.getBytes());
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    private static enum SignType {
        RSA,
        RSA2;

    }
}

