/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.tuple;

import io.github.icodegarden.commons.lang.annotation.Nullable;
import io.github.icodegarden.commons.lang.tuple.TupleEquals;
import io.github.icodegarden.commons.lang.tuple.Tuples;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class NullableTuple2<T1, T2>
implements Iterable<Object>,
Serializable {
    private static final long serialVersionUID = -3518082018884860684L;
    final T1 t1;
    final T2 t2;

    NullableTuple2(T1 t1, T2 t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public T1 getT1() {
        return this.t1;
    }

    public T2 getT2() {
        return this.t2;
    }

    public <R> NullableTuple2<R, T2> mapT1(Function<T1, R> mapper) {
        return new NullableTuple2<R, T2>(mapper.apply(this.t1), this.t2);
    }

    public <R> NullableTuple2<T1, R> mapT2(Function<T2, R> mapper) {
        return new NullableTuple2<T1, R>(this.t1, mapper.apply(this.t2));
    }

    @Nullable
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.t1;
            }
            case 1: {
                return this.t2;
            }
        }
        return null;
    }

    public List<Object> toList() {
        return Arrays.asList(this.toArray());
    }

    public Object[] toArray() {
        return new Object[]{this.t1, this.t2};
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.toList()).iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableTuple2 tuple2 = (NullableTuple2)o;
        return TupleEquals.nullSafeEquals(this.t1, tuple2.t1) && TupleEquals.nullSafeEquals(this.t2, tuple2.t2);
    }

    public int hashCode() {
        int result = this.size();
        result = 31 * result + this.t1.hashCode();
        result = 31 * result + this.t2.hashCode();
        return result;
    }

    public int size() {
        return 2;
    }

    public final String toString() {
        return Tuples.tupleStringRepresentation(this.toArray()).insert(0, '[').append(']').toString();
    }
}

