/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import com.sun.management.OperatingSystemMXBean;
import io.github.icodegarden.commons.lang.tuple.Tuple2;
import io.github.icodegarden.commons.lang.tuple.Tuples;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class SystemUtils {
    public static final DateTimeFormatter STANDARD_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter STANDARD_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter STANDARD_DATETIMEMS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String OS_NAME = System.getProperty("os.name");
    private static boolean isLinuxPlatform = false;
    private static boolean isWindowsPlatform = false;
    private static VMRuntime vmRuntime;

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static String getIp() {
        Tuple2<List<String>, List<String>> tuple2 = SystemUtils.getIpv46s();
        List<String> ipv4Result = tuple2.getT1();
        List<String> ipv6Result = tuple2.getT2();
        if (!ipv4Result.isEmpty()) {
            for (String ip : ipv4Result) {
                if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                return ip;
            }
            return ipv4Result.get(ipv4Result.size() - 1);
        }
        if (!ipv6Result.isEmpty()) {
            return ipv6Result.get(0);
        }
        if (!ipv4Result.isEmpty()) {
            return ipv4Result.get(0);
        }
        return null;
    }

    public static List<String> getIpv4s() {
        Tuple2<List<String>, List<String>> tuple2 = SystemUtils.getIpv46s();
        return tuple2.getT1();
    }

    public static List<String> getIpv6s() {
        Tuple2<List<String>, List<String>> tuple2 = SystemUtils.getIpv46s();
        return tuple2.getT2();
    }

    public static List<String> getIps() {
        Tuple2<List<String>, List<String>> tuple2 = SystemUtils.getIpv46s();
        List<String> t1 = tuple2.getT1();
        t1.addAll((Collection<String>)tuple2.getT2());
        return t1;
    }

    private static Tuple2<List<String>, List<String>> getIpv46s() throws IllegalStateException {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            LinkedList<String> ipv4Result = new LinkedList<String>();
            LinkedList<String> ipv6Result = new LinkedList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(SystemUtils.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(SystemUtils.normalizeHostAddress(address));
                }
            }
            if (ipv4Result.isEmpty()) {
                InetAddress localHost = InetAddress.getLocalHost();
                String localhost = SystemUtils.normalizeHostAddress(localHost);
                ipv4Result.add(localhost);
            }
            return Tuples.of(ipv4Result, ipv6Result);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to obtain local address", e);
        }
    }

    public static String formatIpPort(String ip, int port) {
        return ip + ":" + port;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(":");
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        InetSocketAddress isa = new InetSocketAddress(host, Integer.parseInt(port));
        return isa;
    }

    public static String socketAddress2String(SocketAddress addr) {
        StringBuilder sb = new StringBuilder();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)addr;
        sb.append(inetSocketAddress.getAddress().getHostAddress());
        sb.append(":");
        sb.append(inetSocketAddress.getPort());
        return sb.toString();
    }

    public static SocketChannel connect(SocketAddress remote) {
        return SystemUtils.connect(remote, 5000);
    }

    public static SocketChannel connect(SocketAddress remote, int timeoutMillis) {
        SocketChannel sc = null;
        try {
            sc = SocketChannel.open();
            sc.configureBlocking(true);
            sc.socket().setSoLinger(false, -1);
            sc.socket().setTcpNoDelay(true);
            sc.socket().setReceiveBufferSize(65536);
            sc.socket().setSendBufferSize(65536);
            sc.socket().connect(remote, timeoutMillis);
            sc.configureBlocking(false);
            return sc;
        }
        catch (Exception e) {
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public static VMRuntime getVmRuntime() {
        return vmRuntime;
    }

    public static LocalDateTime now() {
        return SystemClock.now();
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("linux")) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("windows")) {
            isWindowsPlatform = true;
        }
        try {
            vmRuntime = new OperatingSystemMXBeanRuntime();
        }
        catch (Throwable e) {
            vmRuntime = new FallbackRuntime();
        }
    }

    private static class SystemClock {
        private final long period;
        private LocalDateTime now;

        private SystemClock(long period) {
            this.period = period;
            this.now = LocalDateTime.now();
            this.scheduleClockUpdating();
        }

        private static SystemClock instance() {
            return InstanceHolder.INSTANCE;
        }

        public static LocalDateTime now() {
            return SystemClock.instance().now;
        }

        private void scheduleClockUpdating() {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable, SystemClock.class.getSimpleName());
                thread.setDaemon(true);
                return thread;
            });
            scheduler.scheduleWithFixedDelay(() -> {
                this.now = LocalDateTime.now();
            }, this.period, this.period, TimeUnit.MILLISECONDS);
        }

        private static class InstanceHolder {
            public static final SystemClock INSTANCE = new SystemClock(10L);

            private InstanceHolder() {
            }
        }
    }

    private static class FallbackRuntime
    implements VMRuntime {
        private final Runtime runtime = Runtime.getRuntime();

        private FallbackRuntime() {
        }

        @Override
        public long getTotalPhysicalMemorySize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getFreePhysicalMemorySize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getUsedPhysicalMemorySize() {
            return 0L;
        }

        @Override
        public long getTotalSwapSpaceSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getFreeSwapSpaceSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getUsedSwapSpaceSize() {
            return 0L;
        }

        @Override
        public long getJvmMaxMemory() {
            return this.runtime.maxMemory();
        }

        @Override
        public long getJvmTotalMemory() {
            return this.runtime.totalMemory();
        }

        @Override
        public long getJvmFreeMemory() {
            return this.runtime.freeMemory();
        }

        @Override
        public long getJvmUsedMemory() {
            return this.getJvmMaxMemory() - this.getJvmFreeMemory();
        }

        @Override
        public double getSystemCpuLoad() {
            return 0.0;
        }

        @Override
        public double getProcessCpuLoad() {
            return 0.0;
        }
    }

    private static class OperatingSystemMXBeanRuntime
    implements VMRuntime {
        private final OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        private final Runtime runtime = Runtime.getRuntime();
        private final Cache CACHE = new Cache(3000L);

        private OperatingSystemMXBeanRuntime() {
        }

        @Override
        public long getTotalPhysicalMemorySize() {
            return this.systemMXBean.getTotalPhysicalMemorySize();
        }

        @Override
        public long getFreePhysicalMemorySize() {
            return this.systemMXBean.getFreePhysicalMemorySize();
        }

        @Override
        public long getUsedPhysicalMemorySize() {
            return this.systemMXBean.getTotalPhysicalMemorySize() - this.systemMXBean.getFreePhysicalMemorySize();
        }

        @Override
        public long getTotalSwapSpaceSize() {
            return this.systemMXBean.getTotalSwapSpaceSize();
        }

        @Override
        public long getFreeSwapSpaceSize() {
            return this.systemMXBean.getFreeSwapSpaceSize();
        }

        @Override
        public long getUsedSwapSpaceSize() {
            return this.systemMXBean.getTotalSwapSpaceSize() - this.systemMXBean.getFreeSwapSpaceSize();
        }

        @Override
        public long getJvmMaxMemory() {
            return this.runtime.maxMemory();
        }

        @Override
        public long getJvmTotalMemory() {
            return this.runtime.totalMemory();
        }

        @Override
        public long getJvmFreeMemory() {
            return this.runtime.freeMemory();
        }

        @Override
        public long getJvmUsedMemory() {
            return this.getJvmMaxMemory() - this.getJvmFreeMemory();
        }

        @Override
        public double getSystemCpuLoad() {
            return this.systemMXBean.getSystemCpuLoad();
        }

        @Override
        public double getProcessCpuLoad() {
            return this.CACHE.processCpuLoad;
        }

        private class Cache {
            private double processCpuLoad;

            private Cache(long periodMillis) {
                ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
                    Thread thread = new Thread(runnable, "Runtime Cache");
                    thread.setDaemon(true);
                    return thread;
                });
                scheduler.scheduleAtFixedRate(() -> {
                    try {
                        this.processCpuLoad = OperatingSystemMXBeanRuntime.this.systemMXBean.getProcessCpuLoad();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, periodMillis, periodMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static interface VMRuntime {
        public long getTotalPhysicalMemorySize();

        public long getFreePhysicalMemorySize();

        public long getUsedPhysicalMemorySize();

        public long getTotalSwapSpaceSize();

        public long getFreeSwapSpaceSize();

        public long getUsedSwapSpaceSize();

        public long getJvmMaxMemory();

        public long getJvmTotalMemory();

        public long getJvmFreeMemory();

        public long getJvmUsedMemory();

        public double getSystemCpuLoad();

        public double getProcessCpuLoad();

        default public long maxConcurrentThreadsPerSecond() {
            long totalPhysicalMemoryMB = SystemUtils.getVmRuntime().getTotalPhysicalMemorySize() / 1024L / 1024L;
            long maxTotalPhysicalMemoryThreads = totalPhysicalMemoryMB / 120L / 3L * 1000L;
            long xmxMemory = SystemUtils.getVmRuntime().getJvmMaxMemory() / 1024L / 1024L;
            long maxXmxMemoryThreads = xmxMemory / 80L / 3L * 1000L;
            int cpuCores = Runtime.getRuntime().availableProcessors();
            int maxCpuThreads = cpuCores * 3300;
            long max = Math.min(maxTotalPhysicalMemoryThreads, maxXmxMemoryThreads);
            max = Math.min(max, (long)maxCpuThreads);
            return max;
        }
    }
}

