/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import io.github.icodegarden.commons.lang.concurrent.NamedThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public abstract class ThreadPoolUtils {
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadPool(String threadPrefix) {
        return ThreadPoolUtils.newScheduledThreadPool(1, threadPrefix);
    }

    public static ScheduledThreadPoolExecutor newLightResourceScheduledThreadPool(String threadPrefix) {
        return ThreadPoolUtils.newScheduledThreadPool(Math.max(Runtime.getRuntime().availableProcessors() / 2 + 1, 4), threadPrefix);
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, String threadPrefix) {
        return new ScheduledThreadPoolExecutor(corePoolSize, new NamedThreadFactory(threadPrefix));
    }
}

