/*
 * Decompiled with CFR 0.152.
 */
package feign.form.spring.converter;

import feign.form.spring.converter.ByteArrayMultipartFile;
import feign.form.spring.converter.IgnoreKeyCaseMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SpringManyMultipartFilesReader
extends AbstractHttpMessageConverter<MultipartFile[]> {
    private static final Pattern NEWLINES_PATTERN = Pattern.compile("\\R");
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");
    private static final Pattern EQUALITY_SIGN_PATTERN = Pattern.compile("=");
    private final int bufSize;

    public SpringManyMultipartFilesReader(int bufSize) {
        super(MediaType.MULTIPART_FORM_DATA);
        this.bufSize = bufSize;
    }

    protected boolean canWrite(MediaType mediaType) {
        return false;
    }

    protected boolean supports(Class<?> clazz) {
        return MultipartFile[].class == clazz;
    }

    protected MultipartFile[] readInternal(Class<? extends MultipartFile[]> clazz, HttpInputMessage inputMessage) throws IOException {
        HttpHeaders headers = inputMessage.getHeaders();
        if (headers == null) {
            throw new HttpMessageNotReadableException("There are no headers at all.", inputMessage);
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null) {
            throw new HttpMessageNotReadableException("Content-Type is missing.", inputMessage);
        }
        byte[] boundaryBytes = this.getMultiPartBoundary(contentType);
        MultipartStream multipartStream = new MultipartStream(inputMessage.getBody(), boundaryBytes, this.bufSize, null);
        LinkedList<ByteArrayMultipartFile> multiparts = new LinkedList<ByteArrayMultipartFile>();
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            ByteArrayMultipartFile multiPart;
            try {
                multiPart = this.readMultiPart(multipartStream);
            }
            catch (Exception e) {
                throw new HttpMessageNotReadableException("Multipart body could not be read.", (Throwable)e, inputMessage);
            }
            multiparts.add(multiPart);
            nextPart = multipartStream.readBoundary();
        }
        return multiparts.toArray(new ByteArrayMultipartFile[0]);
    }

    protected void writeInternal(MultipartFile[] byteArrayMultipartFiles, HttpOutputMessage outputMessage) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + " does not support writing to HTTP body.");
    }

    private byte[] getMultiPartBoundary(MediaType contentType) {
        String boundaryString = this.unquote(contentType.getParameter("boundary"));
        if (!StringUtils.hasLength((String)boundaryString)) {
            throw new HttpMessageConversionException("Content-Type missing boundary information.");
        }
        return boundaryString.getBytes(StandardCharsets.UTF_8);
    }

    private ByteArrayMultipartFile readMultiPart(MultipartStream multipartStream) throws IOException {
        Map<String, String> multiPartHeaders = this.splitIntoKeyValuePairs(multipartStream.readHeaders(), NEWLINES_PATTERN, COLON_PATTERN, false);
        Map<String, String> contentDisposition = this.splitIntoKeyValuePairs(multiPartHeaders.get("Content-Disposition"), SEMICOLON_PATTERN, EQUALITY_SIGN_PATTERN, true);
        if (!contentDisposition.containsKey("form-data")) {
            throw new HttpMessageConversionException("Content-Disposition is not of type form-data.");
        }
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        multipartStream.readBodyData((OutputStream)bodyStream);
        return new ByteArrayMultipartFile(contentDisposition.get("name"), contentDisposition.get("filename"), multiPartHeaders.get("Content-Type"), bodyStream.toByteArray());
    }

    private Map<String, String> splitIntoKeyValuePairs(String str, Pattern entriesSeparatorPattern, Pattern keyValueSeparatorPattern, boolean unquoteValue) {
        IgnoreKeyCaseMap keyValuePairs = new IgnoreKeyCaseMap();
        if (StringUtils.hasLength((String)str)) {
            String[] tokens;
            for (String token : tokens = entriesSeparatorPattern.split(str)) {
                String[] pair = keyValueSeparatorPattern.split(token.trim(), 2);
                String key = pair[0].trim();
                String value = pair.length > 1 ? pair[1].trim() : "";
                keyValuePairs.put(key, unquoteValue ? this.unquote(value) : value);
            }
        }
        return keyValuePairs;
    }

    private String unquote(String value) {
        if (value == null) {
            return null;
        }
        return this.isSurroundedBy(value, "\"") || this.isSurroundedBy(value, "'") ? value.substring(1, value.length() - 1) : value;
    }

    private boolean isSurroundedBy(String value, String preSuffix) {
        return value.length() > 1 && value.startsWith(preSuffix) && value.endsWith(preSuffix);
    }
}

