/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.config;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateBuilder;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Optional;

public class AuthModuleStateBuilder
implements ModuleStateBuilder {
    public static final String AUTH_MODULE = "auth";
    public static final String AUTH_ENABLED = "auth_enabled";
    public static final String LOGIN_PAGE_ENABLED = "login_page_enabled";
    public static final String AUTH_SYSTEM_TYPE = "auth_system_type";
    public static final String AUTH_ADMIN_REQUEST = "auth_admin_request";
    private boolean cacheable;

    public ModuleState build() {
        ModuleState result = new ModuleState(AUTH_MODULE);
        AuthConfigs authConfigs = (AuthConfigs)((Object)ApplicationUtils.getBean(AuthConfigs.class));
        result.newState(AUTH_ENABLED, (Object)authConfigs.isAuthEnabled());
        result.newState(LOGIN_PAGE_ENABLED, (Object)this.isLoginPageEnabled(authConfigs));
        result.newState(AUTH_SYSTEM_TYPE, (Object)authConfigs.getNacosAuthSystemType());
        result.newState(AUTH_ADMIN_REQUEST, (Object)this.isAdminRequest(authConfigs));
        return result;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    private Boolean isLoginPageEnabled(AuthConfigs authConfigs) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(authConfigs.getNacosAuthSystemType());
        return authPluginService.map(AuthPluginService::isLoginEnabled).orElse(false);
    }

    private Boolean isAdminRequest(AuthConfigs authConfigs) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(authConfigs.getNacosAuthSystemType());
        boolean isAdminRequest = authPluginService.map(AuthPluginService::isAdminRequest).orElse(true);
        if (!isAdminRequest) {
            this.cacheable = true;
        }
        return isAdminRequest;
    }
}

