/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.serveridentity;

import com.alibaba.nacos.auth.serveridentity.DefaultChecker;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityChecker;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIdentityCheckerHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerIdentityCheckerHolder.class);
    private static final ServerIdentityCheckerHolder INSTANCE = new ServerIdentityCheckerHolder();
    private ServerIdentityChecker checker;

    private ServerIdentityCheckerHolder() {
        this.tryGetCheckerBySpi();
    }

    public static ServerIdentityCheckerHolder getInstance() {
        return INSTANCE;
    }

    public ServerIdentityChecker getChecker() {
        return this.checker;
    }

    private synchronized void tryGetCheckerBySpi() {
        Collection checkers = NacosServiceLoader.load(ServerIdentityChecker.class);
        if (checkers.isEmpty()) {
            this.checker = new DefaultChecker();
            LOGGER.info("Not found ServerIdentityChecker implementation from SPI, use default.");
            return;
        }
        if (checkers.size() > 1) {
            this.checker = this.showAllImplementations(checkers);
            return;
        }
        this.checker = (ServerIdentityChecker)checkers.iterator().next();
        LOGGER.info("Found ServerIdentityChecker implementation {}", (Object)this.checker.getClass().getCanonicalName());
    }

    private ServerIdentityChecker showAllImplementations(Collection<ServerIdentityChecker> checkers) {
        ServerIdentityChecker result = checkers.iterator().next();
        for (ServerIdentityChecker each : checkers) {
            LOGGER.warn("Found ServerIdentityChecker implementation {}", (Object)each.getClass().getCanonicalName());
        }
        LOGGER.warn("Found more than one ServerIdentityChecker implementation from SPI, use the first one {}.", (Object)result.getClass().getCanonicalName());
        return result;
    }
}

