/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core;

import io.github.springwolf.core.asyncapi.AsyncApiService;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class SpringwolfInitApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringwolfInitApplicationListener.class);
    private final AsyncApiService asyncApiService;
    private final SpringwolfConfigProperties configProperties;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (this.configProperties.getInitMode() == SpringwolfConfigProperties.InitMode.BACKGROUND) {
            log.debug("Triggering background asyncapi creation");
            new Thread(this.asyncApiService::getAsyncAPI).start();
        } else {
            log.debug("Triggering asyncapi creation");
            this.asyncApiService.getAsyncAPI();
        }
    }

    @Generated
    public SpringwolfInitApplicationListener(AsyncApiService asyncApiService, SpringwolfConfigProperties configProperties) {
        this.asyncApiService = asyncApiService;
        this.configProperties = configProperties;
    }
}

