/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.examples.walkers.xml;

import io.github.springwolf.core.asyncapi.components.examples.walkers.ExampleValueGenerator;
import io.github.springwolf.core.asyncapi.components.examples.walkers.PropertyExample;
import io.github.springwolf.core.asyncapi.components.examples.walkers.SchemaWalker;
import io.github.springwolf.core.asyncapi.components.examples.walkers.xml.ExampleXmlValueSerializer;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExampleXmlValueGenerator
implements ExampleValueGenerator<Node, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExampleXmlValueGenerator.class);
    private final Set<String> SUPPORTED_CONTENT_TYPES = Set.of("text/xml", "application/xml");
    private final Schema<String> OVERRIDE_SCHEMA = new StringSchema();
    private final ExampleXmlValueSerializer exampleXmlValueSerializer;
    private Document document;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final Map<String, Node> exampleCache = new HashMap<String, Node>();
    private final Stack<Element> nodeStack = new Stack();

    public ExampleXmlValueGenerator(ExampleXmlValueSerializer exampleXmlValueSerializer) {
        this.exampleXmlValueSerializer = exampleXmlValueSerializer;
    }

    @Override
    public boolean canHandle(String contentType) {
        return this.SUPPORTED_CONTENT_TYPES.contains(contentType);
    }

    @Override
    public void initialize() {
        try {
            this.nodeStack.clear();
            this.document = this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<String> lookupSchemaName(Schema schema) {
        if (schema.getXml() != null && schema.getXml().getName() != null) {
            return Optional.of(schema.getXml().getName());
        }
        return Optional.ofNullable(schema.getName());
    }

    @Override
    public Optional<Node> createIntegerExample(Integer value, Schema schema) {
        return this.createNodeOrAddAttribute(value.toString(), schema);
    }

    @Override
    public Optional<Node> createDoubleExample(Double value, Schema schema) {
        return this.createNodeOrAddAttribute(value.toString(), schema);
    }

    @Override
    public Optional<Node> createBooleanExample(Boolean value, Schema schema) {
        return this.createNodeOrAddAttribute(value.toString(), schema);
    }

    @Override
    public Element startObject(Optional<String> name) {
        return this.nodeStack.push(this.document.createElement(name.orElseThrow(() -> new SchemaWalker.ExampleGeneratingException("There is no name set for Schema"))));
    }

    @Override
    public void endObject() {
        this.nodeStack.pop();
    }

    @Override
    public void addPropertyExamples(Node object, List<PropertyExample<Node>> properties) {
        if (object == null) {
            throw new IllegalArgumentException("Element to add properties must not be empty");
        }
        try {
            for (PropertyExample<Node> propertyExample : properties) {
                object.appendChild(this.handlePropertyExample(propertyExample));
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private Element wrapNode(String name, Node toWrap) {
        Element rootElement = this.document.createElement(name);
        rootElement.appendChild(toWrap);
        return rootElement;
    }

    private Element handlePropertyExample(PropertyExample<Node> propertyExample) throws ParserConfigurationException {
        Node exampleValue = propertyExample.example();
        if (exampleValue instanceof Element) {
            return (Element)exampleValue;
        }
        if (exampleValue instanceof Text) {
            return this.wrapNode(propertyExample.name(), exampleValue);
        }
        throw new IllegalArgumentException("Unsupported type " + exampleValue.getClass().getSimpleName());
    }

    @Override
    public Optional<Node> createStringExample(String value, Schema schema) {
        return this.createNodeOrAddAttribute(value, schema);
    }

    @Override
    public Optional<Node> createEnumExample(String anEnumValue, Schema schema) {
        return this.createStringExample(anEnumValue, schema);
    }

    @Override
    public Optional<Node> createUnknownSchemaStringTypeExample(String schemaType) {
        return Optional.of(this.document.createTextNode("unknown schema type: " + schemaType));
    }

    @Override
    public Optional<Node> createUnknownSchemaStringFormatExample(String schemaFormat) {
        return Optional.of(this.document.createTextNode("unknown string schema format: " + schemaFormat));
    }

    @Override
    public Node createArrayExample(Optional<String> arrayNameOptional, Node arrayItem) {
        return arrayNameOptional.map(arrayName -> this.wrapNode((String)arrayName, arrayItem)).orElseThrow(() -> new SchemaWalker.ExampleGeneratingException("Unable to add array item to array, because the array schema does not have a name"));
    }

    @Override
    public String prepareForSerialization(Schema schema, Node exampleObject) {
        Optional<Node> objectToWrite = exampleObject instanceof Element ? Optional.of(exampleObject) : this.lookupSchemaName(schema).map(name -> this.wrapNode((String)name, exampleObject));
        if (objectToWrite.isEmpty()) {
            return null;
        }
        try {
            this.document.appendChild(objectToWrite.get());
            String xml = this.exampleXmlValueSerializer.writeDocumentAsXmlString(this.document);
            this.exampleCache.putIfAbsent(this.getCacheKey(schema), exampleObject);
            schema.setType(this.OVERRIDE_SCHEMA.getType());
            schema.setTypes(this.OVERRIDE_SCHEMA.getTypes());
            return xml;
        }
        catch (TransformerException | DOMException e) {
            log.error("Unable to serialize example for schema {}", (Object)schema.getName(), (Object)e);
            return null;
        }
    }

    @Override
    public Node createRaw(Object exampleValue) {
        return this.readXmlString(exampleValue.toString());
    }

    @Override
    public Node getExampleOrNull(Optional<String> fieldName, Schema schema, Object example) {
        String name = this.getCacheKey(schema);
        if (example instanceof Node) {
            return (Node)example;
        }
        if (this.exampleCache.containsKey(name)) {
            Node oldElement = this.exampleCache.get(name);
            Node newElement = this.modifyElementFromCacheIfNeeded(oldElement, fieldName.orElseThrow(() -> new SchemaWalker.ExampleGeneratingException("There is no name set for Schema")));
            return this.document.importNode(newElement, true);
        }
        return null;
    }

    private Node modifyElementFromCacheIfNeeded(Node oldElement, String fieldName) {
        if (oldElement instanceof Element) {
            Document doc = oldElement.getOwnerDocument();
            return doc.renameNode(oldElement, null, fieldName);
        }
        return oldElement;
    }

    @Override
    public Optional<Node> createEmptyObjectExample() {
        return Optional.of(this.document.createTextNode(""));
    }

    private String getCacheKey(Schema schema) {
        return schema.getName();
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private Node readXmlString(String xmlString) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlString));
            Element element = documentBuilder.parse(is).getDocumentElement();
            return this.document.importNode(element, true);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.info("Unable to convert example to XMl Node: {}", (Object)xmlString, (Object)e);
            return null;
        }
    }

    private Optional<Node> createNodeOrAddAttribute(String value, Schema schema) {
        if (!this.nodeStack.isEmpty() && this.isAttribute(schema)) {
            Element currentParent = this.nodeStack.peek();
            this.lookupSchemaName(schema).ifPresent(name -> currentParent.setAttribute((String)name, value));
            return Optional.empty();
        }
        return Optional.of(this.document.createTextNode(value));
    }

    private boolean isAttribute(Schema schema) {
        return schema.getXml() != null && schema.getXml().getAttribute() != null && schema.getXml().getAttribute() != false;
    }
}

