/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.postprocessors;

import io.github.springwolf.core.asyncapi.components.examples.SchemaWalkerProvider;
import io.github.springwolf.core.asyncapi.components.examples.walkers.SchemaWalker;
import io.github.springwolf.core.asyncapi.components.postprocessors.SchemasPostProcessor;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGeneratorPostProcessor
implements SchemasPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExampleGeneratorPostProcessor.class);
    private final SchemaWalkerProvider schemaWalkerProvider;

    @Override
    public void process(Schema schema, Map<String, Schema> definitions, String contentType) {
        if (schema.getExample() == null) {
            log.debug("Generate example for {}", (Object)schema.getName());
            Optional<SchemaWalker> schemaWalkerOptional = this.schemaWalkerProvider.generatorFor(contentType);
            if (schemaWalkerOptional.isPresent()) {
                Object example = schemaWalkerOptional.get().fromSchema(schema, definitions);
                schema.setExample(example);
            } else {
                log.debug("No matching SchemaWalker for contentType {} for example {}", (Object)contentType, (Object)schema.getName());
            }
        }
    }

    @Generated
    public ExampleGeneratorPostProcessor(SchemaWalkerProvider schemaWalkerProvider) {
        this.schemaWalkerProvider = schemaWalkerProvider;
    }
}

