/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.grouping;

import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.asyncapi.v3.model.ReferenceUtil;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.components.Components;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.configuration.docket.AsyncApiGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class GroupingService {
    public AsyncAPI groupAPI(AsyncAPI fullAsyncApi, AsyncApiGroup asyncApiGroup) {
        MarkingContext markingContext = MarkingContext.initFor(asyncApiGroup);
        this.markOperations(fullAsyncApi, asyncApiGroup, markingContext);
        this.markChannels(fullAsyncApi, asyncApiGroup, markingContext);
        this.markMessages(fullAsyncApi, asyncApiGroup, markingContext);
        this.markSchemasInMessageIds(fullAsyncApi, markingContext);
        return AsyncAPI.builder().info(fullAsyncApi.getInfo()).id(fullAsyncApi.getId()).defaultContentType(fullAsyncApi.getDefaultContentType()).servers(fullAsyncApi.getServers()).channels(this.filterChannels(fullAsyncApi, markingContext)).operations(this.filterOperations(fullAsyncApi, markingContext)).components(this.filterComponents(fullAsyncApi, markingContext)).build();
    }

    private void markChannels(AsyncAPI fullAsyncApi, AsyncApiGroup asyncApiGroup, MarkingContext markingContext) {
        if (asyncApiGroup.getChannelNamesToKeep().isEmpty()) {
            return;
        }
        fullAsyncApi.getChannels().values().stream().filter(asyncApiGroup::isMatch).forEach(channel -> {
            markingContext.markedChannelIds.add(channel.getChannelId());
            this.markOperationsInChannel(fullAsyncApi, markingContext, (ChannelObject)channel);
            channel.getMessages().keySet().forEach(markingContext.markedComponentMessageIds::add);
        });
    }

    private void markOperationsInChannel(AsyncAPI fullAsyncApi, MarkingContext markingContext, ChannelObject channel) {
        fullAsyncApi.getOperations().values().stream().filter(operationEntry -> this.matchesOperationInChannel(channel, (Operation)operationEntry)).forEach(operationEntry -> markingContext.markedOperationIds.add(operationEntry.getOperationId()));
    }

    private boolean matchesOperationInChannel(ChannelObject channel, Operation operation) {
        return operation.getChannel().getRef().equals(ChannelReference.fromChannel((String)channel.getChannelId()).getRef());
    }

    private void markOperations(AsyncAPI fullAsyncApi, AsyncApiGroup asyncApiGroup, MarkingContext markingContext) {
        if (asyncApiGroup.getOperationActionsToKeep().isEmpty()) {
            return;
        }
        fullAsyncApi.getOperations().values().stream().filter(asyncApiGroup::isMatch).forEach(operation -> {
            markingContext.markedOperationIds.add(operation.getOperationId());
            GroupingService.markChannelsForOperation(fullAsyncApi, markingContext, operation);
            operation.getMessages().stream().map(MessageReference::getRef).map(ReferenceUtil::getLastSegment).forEach(markingContext.markedComponentMessageIds::add);
        });
    }

    private static void markChannelsForOperation(AsyncAPI fullAsyncApi, MarkingContext markingContext, Operation operation) {
        String operationChannelId = ReferenceUtil.getLastSegment((String)operation.getChannel().getRef());
        fullAsyncApi.getChannels().values().stream().map(ChannelObject::getChannelId).filter(channelId -> channelId.equals(operationChannelId)).forEach(markingContext.markedChannelIds::add);
    }

    private void markMessages(AsyncAPI fullAsyncApi, AsyncApiGroup asyncApiGroup, MarkingContext markingContext) {
        if (asyncApiGroup.getMessageNamesToKeep().isEmpty()) {
            return;
        }
        fullAsyncApi.getComponents().getMessages().values().stream().map(message -> (MessageObject)message).filter(asyncApiGroup::isMatch).forEach(message -> {
            markingContext.markedComponentMessageIds.add(message.getMessageId());
            String messageReference = MessageReference.toComponentMessage((String)message.getMessageId()).getRef();
            fullAsyncApi.getChannels().values().stream().filter(channelEntry -> this.matchesMessageForChannel((ChannelObject)channelEntry, messageReference)).forEach(channelEntry -> markingContext.markedChannelIds.add(channelEntry.getChannelId()));
            fullAsyncApi.getOperations().entrySet().stream().filter(operationEntry -> this.matchesMessageForOperation((MessageObject)message, (Map.Entry<String, Operation>)operationEntry)).forEach(operationEntry -> markingContext.markedOperationIds.add((String)operationEntry.getKey()));
        });
    }

    private boolean matchesMessageForChannel(ChannelObject channel, String messageReference) {
        return channel.getMessages().values().stream().map(messageRef -> (MessageReference)messageRef).anyMatch(messageRef -> messageRef.getRef().equals(messageReference));
    }

    private boolean matchesMessageForOperation(MessageObject message, Map.Entry<String, Operation> operationEntry) {
        return operationEntry.getValue().getMessages().stream().anyMatch(operationMessage -> operationMessage.getRef().endsWith(message.getMessageId()));
    }

    private void markSchemasInMessageIds(AsyncAPI fullAsyncApi, MarkingContext markingContext) {
        HashSet<String> schemaIds = new HashSet<String>();
        List<MessageObject> messages = fullAsyncApi.getComponents().getMessages().values().stream().map(message -> (MessageObject)message).filter(message -> markingContext.markedComponentMessageIds.contains(message.getMessageId())).toList();
        this.markMessageHeadersForSchemas(messages, schemaIds);
        this.markMessagePayloadsForSchemas(messages, schemaIds);
        this.markSchemas(fullAsyncApi, markingContext, schemaIds);
    }

    private void markMessageHeadersForSchemas(List<MessageObject> messages, Set<String> schemaIds) {
        messages.stream().map(MessageObject::getHeaders).filter(Objects::nonNull).map(MessageHeaders::getReference).map(MessageReference::getRef).map(ReferenceUtil::getLastSegment).forEach(schemaIds::add);
    }

    private void markMessagePayloadsForSchemas(List<MessageObject> messages, Set<String> schemaIds) {
        messages.stream().map(MessageObject::getPayload).map(MessagePayload::getMultiFormatSchema).filter(Objects::nonNull).map(MultiFormatSchema::getSchema).filter(el -> el instanceof MessageReference).map(el -> (MessageReference)el).map(MessageReference::getRef).map(ReferenceUtil::getLastSegment).forEach(schemaIds::add);
    }

    private void markSchemas(AsyncAPI fullAsyncApi, MarkingContext markingContext, Set<String> schemaIds) {
        schemaIds.stream().map(schemaId -> Pair.of((Object)schemaId, (Object)fullAsyncApi.getComponents().getSchemas().getOrDefault(schemaId, null))).filter(entry -> entry.getValue() != null).forEach(schemaEntry -> {
            markingContext.markedComponentSchemaIds.add((String)schemaEntry.getKey());
            Set<String> nestedSchemas = GroupingService.findUnmarkedNestedSchemas(markingContext, (SchemaObject)schemaEntry.getValue());
            if (!nestedSchemas.isEmpty()) {
                this.markSchemas(fullAsyncApi, markingContext, nestedSchemas);
            }
        });
    }

    private static Set<String> findUnmarkedNestedSchemas(MarkingContext markingContext, SchemaObject schema) {
        Stream<Object> propertySchemas = schema.getProperties() != null ? schema.getProperties().values().stream().filter(el -> el instanceof ComponentSchema).map(el -> (ComponentSchema)el) : Stream.empty();
        Stream referencedSchemas = Stream.of(schema.getAllOf(), schema.getAnyOf(), schema.getOneOf()).filter(Objects::nonNull).flatMap(Collection::stream);
        Stream<ComponentSchema> referencedSchemaElements = Stream.of(schema.getNot(), schema.getItems()).filter(Objects::nonNull);
        return Stream.concat(propertySchemas, Stream.concat(referencedSchemas, referencedSchemaElements)).map(ComponentSchema::getReference).filter(Objects::nonNull).map(MessageReference::getRef).map(ReferenceUtil::getLastSegment).filter(schemaId -> !markingContext.markedComponentSchemaIds.contains(schemaId)).collect(Collectors.toSet());
    }

    private Map<String, ChannelObject> filterChannels(AsyncAPI fullAsyncApi, MarkingContext markingContext) {
        return fullAsyncApi.getChannels().values().stream().filter(channel -> markingContext.isChannelMarked(channel.getChannelId())).map(channel -> {
            Map<String, Message> filteredMessagesInChannel = channel.getMessages().entrySet().stream().filter(messageEntry -> markingContext.isComponentMessageMarked((String)messageEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return channel.toBuilder().messages(filteredMessagesInChannel).build();
        }).collect(Collectors.toMap(ChannelObject::getChannelId, el -> el));
    }

    private Map<String, Operation> filterOperations(AsyncAPI fullAsyncApi, MarkingContext markingContext) {
        return fullAsyncApi.getOperations().entrySet().stream().filter(entry -> markingContext.isOperationMarked((String)entry.getKey())).map(entry -> {
            List filteredMessagesInOperation = ((Operation)entry.getValue()).getMessages().stream().filter(markingContext::isComponentMessageMarked).collect(Collectors.toList());
            Operation updatedOperation = ((Operation)entry.getValue()).toBuilder().messages(filteredMessagesInOperation).build();
            return Map.entry((String)entry.getKey(), updatedOperation);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Components filterComponents(AsyncAPI fullAsyncApi, MarkingContext markingContext) {
        Map<String, Message> messages = fullAsyncApi.getComponents().getMessages().entrySet().stream().filter(entry -> markingContext.isComponentMessageMarked((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, SchemaObject> schemas = fullAsyncApi.getComponents().getSchemas().entrySet().stream().filter(entry -> markingContext.isComponentSchemaMarked((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Components.builder().messages(messages).schemas(schemas).build();
    }

    @Generated
    public GroupingService() {
    }

    private static class MarkingContext {
        private final boolean keepEverything;
        private final Set<String> markedOperationIds = new HashSet<String>();
        private final Set<String> markedChannelIds = new HashSet<String>();
        private final Set<String> markedComponentMessageIds = new HashSet<String>();
        private final Set<String> markedComponentSchemaIds = new HashSet<String>();

        public static MarkingContext initFor(AsyncApiGroup asyncApiGroup) {
            boolean keepEverything = asyncApiGroup.getOperationActionsToKeep().isEmpty() && asyncApiGroup.getChannelNamesToKeep().isEmpty() && asyncApiGroup.getMessageNamesToKeep().isEmpty();
            return new MarkingContext(keepEverything);
        }

        public boolean isChannelMarked(String channelId) {
            return this.keepEverything || this.markedChannelIds.contains(channelId);
        }

        public boolean isOperationMarked(String operationId) {
            return this.keepEverything || this.markedOperationIds.contains(operationId);
        }

        public boolean isComponentMessageMarked(String messageId) {
            return this.keepEverything || this.markedComponentMessageIds.contains(messageId);
        }

        public boolean isComponentMessageMarked(MessageReference messageEntry) {
            return this.keepEverything || this.markedComponentMessageIds.contains(ReferenceUtil.getLastSegment((String)messageEntry.getRef()));
        }

        public boolean isComponentSchemaMarked(String schemaId) {
            return this.keepEverything || this.markedComponentSchemaIds.contains(schemaId);
        }

        @Generated
        public MarkingContext(boolean keepEverything) {
            this.keepEverything = keepEverything;
        }
    }
}

