/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels.annotations;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.core.asyncapi.scanners.channels.ChannelsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.channel.SpringAnnotationChannelService;
import io.github.springwolf.core.asyncapi.scanners.common.message.SpringAnnotationMessagesService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationClassLevelChannelsScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation>
implements ChannelsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationClassLevelChannelsScanner.class);
    private final Class<ClassAnnotation> classAnnotationClass;
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final SpringAnnotationMessagesService<ClassAnnotation> springAnnotationMessagesService;
    private final SpringAnnotationChannelService<ClassAnnotation> springAnnotationChannelService;

    @Override
    public List<ChannelObject> scan(Class<?> clazz) {
        return AnnotationScannerUtil.findAnnotatedMethods(clazz, this.classAnnotationClass, this.methodAnnotationClass, this::mapClassToChannel).toList();
    }

    private Stream<ChannelObject> mapClassToChannel(Class<?> component, Set<MethodAndAnnotation<MethodAnnotation>> annotatedMethods) {
        ClassAnnotation classAnnotation = AnnotationUtil.findFirstAnnotationOrThrow(this.classAnnotationClass, component);
        Set<Method> methods = annotatedMethods.stream().map(MethodAndAnnotation::method).collect(Collectors.toSet());
        HashMap<String, MessageReference> messages = new HashMap<String, MessageReference>(this.springAnnotationMessagesService.buildMessages(classAnnotation, methods, SpringAnnotationMessagesService.MessageType.CHANNEL));
        return this.mapClassToChannel(classAnnotation, messages);
    }

    private Stream<ChannelObject> mapClassToChannel(ClassAnnotation classAnnotation, Map<String, Message> messages) {
        return Stream.of(this.springAnnotationChannelService.buildChannel(classAnnotation, messages));
    }

    @Generated
    public SpringAnnotationClassLevelChannelsScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, SpringAnnotationMessagesService<ClassAnnotation> springAnnotationMessagesService, SpringAnnotationChannelService<ClassAnnotation> springAnnotationChannelService) {
        this.classAnnotationClass = classAnnotationClass;
        this.methodAnnotationClass = methodAnnotationClass;
        this.springAnnotationMessagesService = springAnnotationMessagesService;
        this.springAnnotationChannelService = springAnnotationChannelService;
    }
}

