/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.classes.spring.annotations;

import io.github.springwolf.core.asyncapi.scanners.classes.ClassScanner;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class AnnotationClassScanner<T extends Annotation>
implements ClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotationClassScanner.class);
    private final Class<T> annotation;
    private final AsyncApiDocketService asyncApiDocketService;
    private final Environment environment;

    @Override
    public Set<Class<?>> scan() {
        String basePackages = this.asyncApiDocketService.getAsyncApiDocket().getBasePackage();
        if (!StringUtils.hasText((String)basePackages)) {
            throw new IllegalArgumentException("Base package must not be blank");
        }
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false, this.environment);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotation));
        return Arrays.stream(basePackages.replaceAll("\\s", "").split(",")).flatMap(basePackage -> {
            log.debug("Scanning for {} classes in {}", (Object)this.annotation.getSimpleName(), basePackage);
            return provider.findCandidateComponents(basePackage).stream().map(BeanDefinition::getBeanClassName).map(this::getClass).filter(Optional::isPresent).map(Optional::get);
        }).collect(Collectors.toSet());
    }

    private Optional<Class<?>> getClass(String className) {
        try {
            log.debug("Found candidate class: {}", (Object)className);
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed to get class for name: {}", (Object)className);
            return Optional.empty();
        }
    }

    @Generated
    public AnnotationClassScanner(Class<T> annotation, AsyncApiDocketService asyncApiDocketService, Environment environment) {
        this.annotation = annotation;
        this.asyncApiDocketService = asyncApiDocketService;
        this.environment = environment;
    }
}

