/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common;

import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private static final Comparator<MessageObject> byMessageId = Comparator.comparing(MessageObject::getMessageId);
    private static final Supplier<Set<MessageObject>> messageSupplier = () -> new TreeSet<MessageObject>(byMessageId);

    private MessageHelper() {
    }

    public static Map<String, MessageReference> toMessagesMap(Set<MessageObject> messages) {
        Function<MessageObject, MessageReference> aggregator = MessageReference::toComponentMessage;
        return MessageHelper.toMessageReferences(messages, aggregator);
    }

    public static Map<String, MessageReference> toOperationsMessagesMap(String channelId, Set<MessageObject> messages) {
        if (channelId == null || channelId.isBlank()) {
            throw new IllegalArgumentException("channelId must not be empty");
        }
        Function<MessageObject, MessageReference> aggregator = message -> MessageReference.toChannelMessage((String)channelId, (String)message.getMessageId());
        return MessageHelper.toMessageReferences(messages, aggregator);
    }

    private static Map<String, MessageReference> toMessageReferences(Set<MessageObject> messages, Function<MessageObject, MessageReference> messageReferenceFunction) {
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("messages must not be empty");
        }
        return new ArrayList(messages.stream().collect(Collectors.toCollection(messageSupplier))).stream().collect(Collectors.toMap(MessageObject::getMessageId, messageReferenceFunction));
    }
}

