/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.annotation;

import io.github.springwolf.core.asyncapi.scanners.common.annotation.AllMethods;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.swagger.v3.oas.annotations.Hidden;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class AnnotationScannerUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotationScannerUtil.class);
    private static final Set<String> typicalJavaMethods = Set.of("clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait");

    private AnnotationScannerUtil() {
    }

    public static <C extends Annotation, M extends Annotation, R> Stream<R> findAnnotatedMethods(Class<?> clazz, Class<C> classAnnotationClass, Class<M> methodAnnotationClass, BiFunction<Class<?>, Set<MethodAndAnnotation<M>>, Stream<R>> transformer) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotation", (Object)clazz.getName(), (Object)classAnnotationClass.getName());
        Set methods = Stream.of(clazz).filter(it -> AnnotationScannerUtil.isClassRelevant(it, classAnnotationClass)).peek(it -> log.debug("Mapping class \"{}\"", (Object)it.getName())).flatMap(it -> AnnotationScannerUtil.findAnnotatedMethods(it, methodAnnotationClass)).collect(Collectors.toSet());
        if (methods.isEmpty()) {
            return Stream.empty();
        }
        return transformer.apply(clazz, methods);
    }

    static <A extends Annotation> boolean isClassRelevant(Class<?> clazz, Class<A> annotationClass) {
        return AnnotationScannerUtil.isNotHidden(clazz) && AnnotationUtil.findFirstAnnotation(annotationClass, clazz) != null;
    }

    public static <A extends Annotation> Stream<MethodAndAnnotation<A>> findAnnotatedMethods(Class<?> clazz, Class<A> methodAnnotationClass) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)methodAnnotationClass.getName());
        Stream<Method> methods = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(clazz)).filter(AnnotationScannerUtil::isMethodInSourceCode).filter(AnnotationScannerUtil::isNotTypicalJavaMethod).filter(AnnotationScannerUtil::isNotHidden);
        if (methodAnnotationClass == AllMethods.class) {
            return methods.peek(method -> log.debug("Mapping method \"{}\"", (Object)method.getName())).map(method -> new MethodAndAnnotation<Object>((Method)method, null));
        }
        return methods.filter(method -> AnnotationUtil.findFirstAnnotation(methodAnnotationClass, method) != null).peek(method -> log.debug("Mapping method \"{}\"", (Object)method.getName())).flatMap(method -> AnnotationUtil.findAnnotations(methodAnnotationClass, method).stream().map(annotation -> new MethodAndAnnotation<Annotation>((Method)method, (Annotation)annotation)));
    }

    private static boolean isMethodInSourceCode(Method method) {
        return !method.isSynthetic();
    }

    private static boolean isNotHidden(AnnotatedElement element) {
        return Objects.isNull(AnnotationUtil.findFirstAnnotation(Hidden.class, element));
    }

    private static boolean isNotTypicalJavaMethod(Method method) {
        return !typicalJavaMethods.contains(method.getName());
    }
}

