/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.channel;

import io.github.springwolf.asyncapi.v3.model.ReferenceUtil;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.server.Server;
import io.github.springwolf.asyncapi.v3.model.server.ServerReference;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.scanners.common.AsyncAnnotationProvider;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AsyncAnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.message.AsyncAnnotationMessageService;
import io.github.springwolf.core.asyncapi.scanners.common.operation.AsyncAnnotationOperationService;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationChannelService<Annotation extends Annotation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationChannelService.class);
    private final AsyncAnnotationProvider<Annotation> asyncAnnotationProvider;
    private final AsyncAnnotationOperationService<Annotation> asyncAnnotationOperationService;
    private final AsyncAnnotationMessageService asyncAnnotationMessageService;
    private final StringValueResolver stringValueResolver;
    private final AsyncApiDocketService asyncApiDocketService;

    public ChannelObject buildChannel(MethodAndAnnotation<Annotation> methodAndAnnotation) {
        AsyncOperation operationAnnotation = this.asyncAnnotationProvider.getAsyncOperation((Annotation)methodAndAnnotation.annotation());
        ChannelObject.ChannelObjectBuilder channelBuilder = ChannelObject.builder();
        List<String> servers = AsyncAnnotationUtil.getServers(operationAnnotation, this.stringValueResolver);
        if (servers != null && !servers.isEmpty()) {
            Operation operation = this.asyncAnnotationOperationService.buildOperation(operationAnnotation, Set.of(methodAndAnnotation.method()));
            this.validateServers(servers, operation.getTitle());
            channelBuilder.servers(servers.stream().map(ServerReference::fromServer).toList());
        }
        String channelName = this.stringValueResolver.resolveStringValue(operationAnnotation.channelName());
        String channelId = ReferenceUtil.toValidId((String)channelName);
        MessageObject message = this.asyncAnnotationMessageService.buildMessage(operationAnnotation, methodAndAnnotation.method());
        ChannelObject channel = channelBuilder.channelId(channelId).address(channelName).messages(Map.of(message.getMessageId(), MessageReference.toComponentMessage((MessageObject)message))).build();
        return channel;
    }

    void validateServers(List<String> serversFromOperation, String operationId) {
        if (!serversFromOperation.isEmpty()) {
            Map<String, Server> asyncApiServers = this.asyncApiDocketService.getAsyncApiDocket().getServers();
            if (asyncApiServers == null || asyncApiServers.isEmpty()) {
                throw new IllegalArgumentException(String.format("Operation '%s' defines server refs (%s) but there are no servers defined in this AsyncAPI.", operationId, serversFromOperation));
            }
            for (String server : serversFromOperation) {
                if (asyncApiServers.containsKey(server)) continue;
                throw new IllegalArgumentException(String.format("Operation '%s' defines unknown server ref '%s'. This AsyncApi defines these server(s): %s", operationId, server, asyncApiServers.keySet()));
            }
        }
    }

    @Generated
    public AsyncAnnotationChannelService(AsyncAnnotationProvider<Annotation> asyncAnnotationProvider, AsyncAnnotationOperationService<Annotation> asyncAnnotationOperationService, AsyncAnnotationMessageService asyncAnnotationMessageService, StringValueResolver stringValueResolver, AsyncApiDocketService asyncApiDocketService) {
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.asyncAnnotationOperationService = asyncAnnotationOperationService;
        this.asyncAnnotationMessageService = asyncAnnotationMessageService;
        this.stringValueResolver = stringValueResolver;
        this.asyncApiDocketService = asyncApiDocketService;
    }
}

