/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.headers;

import io.github.springwolf.asyncapi.v3.model.schema.Schema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.common.headers.AsyncHeadersNotDocumented;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import io.github.springwolf.core.asyncapi.schemas.SwaggerSchemaService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Header;

public class HeaderClassExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeaderClassExtractor.class);
    private final SwaggerSchemaService schemaService;

    public SchemaObject extractHeader(Method method, PayloadSchemaObject payload) {
        String methodName = String.format("%s::%s", method.getDeclaringClass().getSimpleName(), method.getName());
        log.debug("Extract header for {}", (Object)methodName);
        SchemaObject headers = SchemaObject.builder().type("object").title(payload.name() + "Headers").properties(new HashMap()).build();
        for (Parameter argument : method.getParameters()) {
            if (!argument.isAnnotationPresent(Header.class)) continue;
            Header headerAnnotation = argument.getAnnotation(Header.class);
            String headerName = HeaderClassExtractor.getHeaderAnnotationName(headerAnnotation);
            SwaggerSchemaService.ExtractedSchemas extractedSchema = this.schemaService.extractSchema(argument.getType());
            SchemaObject schema = extractedSchema.rootSchema().getSchema();
            if (schema == null && extractedSchema.referencedSchemas().size() == 1) {
                schema = (Schema)extractedSchema.referencedSchemas().values().iterator().next();
            }
            if (schema != null) {
                headers.getProperties().put(headerName, schema);
                continue;
            }
            log.debug("Unable to extract schema for header {} in method {}", (Object)headerName, (Object)methodName);
        }
        if (headers.getProperties().isEmpty()) {
            return AsyncHeadersNotDocumented.NOT_DOCUMENTED;
        }
        return headers;
    }

    private static String getHeaderAnnotationName(Header annotation) {
        if (!annotation.name().isBlank()) {
            return annotation.name();
        }
        return annotation.value();
    }

    @Generated
    public HeaderClassExtractor(SwaggerSchemaService schemaService) {
        this.schemaService = schemaService;
    }
}

