/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.headers;

import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HeaderSchemaObjectMerger {
    public static SchemaObject merge(SchemaObject initial, SchemaObject ... schemas) {
        int additionalProperties = Arrays.stream(schemas).filter(schemaObject -> schemaObject != null && schemaObject.getProperties() != null).mapToInt(schema -> schema.getProperties().size()).sum();
        if (additionalProperties == 0) {
            return initial;
        }
        SchemaObject.SchemaObjectBuilder headerSchemaBuilder = SchemaObject.builder().type("object");
        String title = initial.getTitle();
        String description = initial.getDescription();
        HashMap<String, Object> headerProperties = new HashMap<String, Object>(initial.getProperties());
        for (SchemaObject schema2 : schemas) {
            if (schema2 == null) continue;
            if (StringUtils.isBlank((CharSequence)description)) {
                description = schema2.getDescription();
            }
            schema2.getProperties().forEach(headerProperties::putIfAbsent);
        }
        return headerSchemaBuilder.title(HeaderSchemaObjectMerger.generateTitle(initial, headerProperties)).description(description).properties(headerProperties).build();
    }

    public static String generateHeaderSchemaName(Object object) {
        return HeaderSchemaObjectMerger.generateHeaderSchemaName("Headers", object);
    }

    private static String generateHeaderSchemaName(String prefix, Object object) {
        return prefix + "-" + Math.abs(object.hashCode());
    }

    private static String generateTitle(SchemaObject initial, Map<String, Object> headerProperties) {
        if (StringUtils.isBlank((CharSequence)initial.getTitle())) {
            return HeaderSchemaObjectMerger.generateHeaderSchemaName(headerProperties);
        }
        return HeaderSchemaObjectMerger.generateHeaderSchemaName(initial.getTitle(), headerProperties.hashCode());
    }
}

