/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.message;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.MessageHelper;
import io.github.springwolf.core.asyncapi.scanners.common.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderSchemaObjectMerger;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadMethodService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMessagesService<ClassAnnotation extends Annotation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMessagesService.class);
    private final BindingFactory<ClassAnnotation> bindingFactory;
    private final AsyncHeadersBuilder asyncHeadersBuilder;
    private final PayloadMethodService payloadMethodService;
    private final HeaderClassExtractor headerClassExtractor;
    private final ComponentsService componentsService;

    public Map<String, MessageReference> buildMessages(ClassAnnotation classAnnotation, Set<Method> methods, MessageType messageType) {
        Set<MessageObject> messages = methods.stream().map(method -> this.buildMessage(classAnnotation, (Method)method)).collect(Collectors.toSet());
        if (messageType == MessageType.OPERATION) {
            String channelId = this.bindingFactory.getChannelName(classAnnotation);
            return MessageHelper.toOperationsMessagesMap(channelId, messages);
        }
        return MessageHelper.toMessagesMap(messages);
    }

    private MessageObject buildMessage(ClassAnnotation classAnnotation, Method method) {
        PayloadSchemaObject payloadSchema = this.payloadMethodService.extractSchema(method);
        SchemaObject headerSchema = this.asyncHeadersBuilder.buildHeaders(payloadSchema);
        SchemaObject headers = this.headerClassExtractor.extractHeader(method, payloadSchema);
        SchemaObject mergedHeaderSchema = HeaderSchemaObjectMerger.merge(headerSchema, headers);
        String headerSchemaName = this.componentsService.registerSchema(mergedHeaderSchema);
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(classAnnotation, headerSchema);
        MessagePayload payload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema(payloadSchema.payload()).build());
        MessageObject message = MessageObject.builder().messageId(payloadSchema.name()).name(payloadSchema.name()).title(payloadSchema.title()).description(null).payload(payload).headers(MessageHeaders.of((MessageReference)MessageReference.toSchema((String)headerSchemaName))).bindings(messageBinding).build();
        this.componentsService.registerMessage(message);
        return message;
    }

    @Generated
    public SpringAnnotationMessagesService(BindingFactory<ClassAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, PayloadMethodService payloadMethodService, HeaderClassExtractor headerClassExtractor, ComponentsService componentsService) {
        this.bindingFactory = bindingFactory;
        this.asyncHeadersBuilder = asyncHeadersBuilder;
        this.payloadMethodService = payloadMethodService;
        this.headerClassExtractor = headerClassExtractor;
        this.componentsService = componentsService;
    }

    public static enum MessageType {
        CHANNEL,
        OPERATION;

    }
}

