/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.operation;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.ReferenceUtil;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.common.AsyncAnnotationProvider;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AsyncAnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.message.AsyncAnnotationMessageService;
import io.github.springwolf.core.asyncapi.scanners.common.utils.TextUtils;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationIdHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationOperationService<Annotation extends Annotation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationOperationService.class);
    private final AsyncAnnotationProvider<Annotation> asyncAnnotationProvider;
    private final List<OperationBindingProcessor> operationBindingProcessors;
    private final AsyncAnnotationMessageService asyncAnnotationMessageService;
    private final StringValueResolver stringValueResolver;

    public Operation buildOperation(AsyncOperation asyncOperation, Set<Method> methods) {
        String channelName = this.stringValueResolver.resolveStringValue(asyncOperation.channelName());
        String channelId = ReferenceUtil.toValidId((String)channelName);
        Method method = (Method)methods.stream().findFirst().orElseThrow();
        List<MessageReference> messages = methods.stream().map(m -> this.asyncAnnotationMessageService.buildMessage(asyncOperation, (Method)m)).map(m -> MessageReference.toChannelMessage((String)channelId, (MessageObject)m)).collect(Collectors.toList());
        return this.buildOperation(asyncOperation, method, channelId, messages);
    }

    private Operation buildOperation(AsyncOperation asyncOperation, Method method, String channelId, List<MessageReference> messages) {
        String operationId = OperationIdHelper.buildOperationId(channelId, this.asyncAnnotationProvider.getOperationType(), method.getName());
        String description = this.stringValueResolver.resolveStringValue(asyncOperation.description());
        description = StringUtils.isBlank((CharSequence)description) ? "Auto-generated description" : TextUtils.trimIndent(description);
        String operationTitle = StringUtils.joinWith((String)"_", (Object[])new Object[]{channelId, this.asyncAnnotationProvider.getOperationType().type});
        Map<String, OperationBinding> operationBinding = AsyncAnnotationUtil.processOperationBindingFromAnnotation(method, this.operationBindingProcessors);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        return Operation.builder().operationId(operationId).channel(ChannelReference.fromChannel((String)channelId)).action(this.asyncAnnotationProvider.getOperationType()).description(description).title(operationTitle).messages(messages).bindings(opBinding).build();
    }

    @Generated
    public AsyncAnnotationOperationService(AsyncAnnotationProvider<Annotation> asyncAnnotationProvider, List<OperationBindingProcessor> operationBindingProcessors, AsyncAnnotationMessageService asyncAnnotationMessageService, StringValueResolver stringValueResolver) {
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.operationBindingProcessors = operationBindingProcessors;
        this.asyncAnnotationMessageService = asyncAnnotationMessageService;
        this.stringValueResolver = stringValueResolver;
    }
}

